' Updated for Static IP in Adapters and Teams
Option Explicit
Dim colArgs, strSettingsFile, SValueSet, SessionObject, NetServiceObject
Dim strIfSetFile, strFileName, strSave, strChoices, strInput, bError, strNetSerObjPath
Dim strSettingName, strFname, index, bUserInput, bModified, NetServiceSet
Dim totalAdapters, totalTeams, existTotalAdapters, bNewTeam, ServiceObject, FinalTargetObj
Dim AdapterSets, AdapterObj, wbemServices, strComputer, bHasTeamOrVLAN, wbemServices1
Dim bMisMatch, bSelected, strSettingsIndex, strCapabilities, strAdapterName, strAdapterPCIDeviceID, strOrgDispName
Dim arrPrivDesc(), arrTeamPrivDesc(), Adapters(), Captions(), Teams() ,AdapterPath(), AdapterPCIDeviceID()
Dim TeamsObjSet, TeamObj,Temp ,VLANObjSet, VLANObj, virtualAdapterSets, virtualAdapterObj
Dim bMFOEnabled, shell, IPFilePath
const HKEY_LOCAL_MACHINE = &H80000002
Dim strRemove, strRemoveAnsOnly
Dim OSVersion, OSProductType
Dim isPowerManagementSupported
dim bNoAns
bNoAns = false
isPowerManagementSupported = False

dim strOEMCustomizeableValue

'Dim blTenGigFETeamError
'blTenGigFETeamError = False

'During DMiX-to-DMiX upgrade scenarios only, the PermanentAddress 
'will be stored in the config file instead of the PCIDeviceID.
'The is due to the fact that the initial release of DMiX 
'did not have support for the PCIDeviceID property.
Dim bIsUpgrade		
bIsUpgrade = False	'Initialize to FALSE.
dim bExpressTeam 
bExpressTeam = FALSE	'Initialize to FALSE.
Dim InParameterETObj,TempETObject,OutParameterETObj


Set shell = CreateObject("WScript.Shell")
'  	Set env = shell.Environment("USER")

IPFilePath = shell.ExpandEnvironmentStrings("%TEMP%")
IPFilePath = IPFilePath & "\StaticIP.txt"

' arrays used to store TeamedMemberAdapter Information
' poor workaround for Wscript 5.1 (Windows 2000) - classes are not supported
Dim TeamedMemberAdapterName(64, 10)
Dim TeamedMemberAdapterPCIDeviceID(64, 10)
Dim TeamedMemberAdapterPreferredPrimarySetting(64, 10)
' Dim TeamedMemberAdapterGroupComponentSetting(64, 10) ' not currently used 
Dim TeamedMemberAdapterPartComponentSetting(64, 10)

Const maxAdapterTeamVLANs = 64
Const maxAdapterTeam = 64

Const wbemFlagAmendedCreateOnly = &h20002  
Const wbemFlagAmendedUpdateOnly = &h20001

Const maxSettings = 1000
Const DefaultFileName = "WmiConf.txt"

Const SLA_TEAM_TYPE = "2"
Const GEC_TEAM_TYPE = "3"

Set colArgs = WScript.Arguments
strComputer = "."

CheckAdminRights()

GetOSVersion()

' Check submitted arguments, show Usage for no arguments, ? or help arguments
If (WScript.Arguments.Count = 0) Then 
	PrintUsage()
Else 
	If (WScript.Arguments(0) = "?" ) OR (LCase(WScript.Arguments(0)) = "help") Then
		PrintUsage()
	Else
		' Assign variables after determining what combination of options have been submitted
		If WScript.Arguments.Count = 1 Then
			strIfSetFile = "FALSE"
			If LCase(WScript.Arguments(0)) = "save" Then
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "restore" Then
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "upsave" Then
				bIsUpgrade = True
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "uprestore" Then
				bIsUpgrade = True
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "remove" Then
				strRemove = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "removeansonly" Then
				strRemove = "TRUE"
				strRemoveAnsOnly  = "TRUE"
			End If
		Else
			If LCase(WScript.Arguments(0)) = "save" Then
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "restore" Then	
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "upsave" Then
				bIsUpgrade = True
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "uprestore" Then
				bIsUpgrade = True
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "remove" Then
				MsgBox "remove all"
				strRemove = "TRUE"	
			ElseIf LCase(WScript.Arguments(0)) = "removeansonly" Then
				MsgBox "ans only"
				strRemove = "TRUE"
				strRemoveAnsOnly  = "TRUE"
			End If
			If LCase(WScript.Arguments(1)) = "default" Then
				strIfSetFile = "FALSE"
			Else
				strIfSetFile = "TRUE"
			End If
		End If
	
		'Execute Save, Restore, Install or Remove on what data user submitted, depending on the arguments set above			
		If (strIfSetFile = "FALSE") Then
			strSettingsFile = defaultFileName
			If (bIsUpgrade = True) AND (strSave = "TRUE") Then
				WScript.Echo "Executing Save during upgrade on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf (bIsUpgrade = True) AND (strSave = "FALSE") Then
				WScript.Echo "Executing Restore during upgrade on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			ElseIf strSave = "TRUE" Then		
				WScript.Echo "Executing Save on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf strSave = "FALSE" Then
				WScript.Echo "Executing Restore on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			Elseif strRemove  = "TRUE" Then
				WScript.Echo "Executing Remove on local computer"
				Remove()
			Else				
				WScript.Echo "Unrecognized keyword:  " & WScript.Arguments(0) & ".  Keyword must be 'save' or 'restore' or 'remove' only."
			End If
		Else
			strSettingsFile = WScript.Arguments(1)
			If (bIsUpgrade = True) AND (strSave = "TRUE") Then
				WScript.Echo "Executing Save during upgrade on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf (bIsUpgrade = True) AND (strSave = "FALSE") Then
				WScript.Echo "Executing Restore during upgrade on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			ElseIf strSave = "TRUE" Then
				WScript.Echo "Executing Save on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf strSave = "FALSE" Then
				WScript.Echo "Executing Restore on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			Elseif strRemove  = "TRUE" Then
				WScript.Echo "Executing Remove on local computer with " & strSettingsFile
				Remove()
			Else
				WScript.Echo "Unrecognized keyword:  " & WScript.Arguments(0) & ".  Keyword must be 'save' or 'restore' or 'remove' only."
			End If
		End If
	End If
End If

Sub GetOSVersion()
	Dim objWMI, objItem, colItems

	Set objWMI = GetObject("winmgmts:\\.\root\cimv2")
	Set colItems = objWMI.ExecQuery("Select * from Win32_OperatingSystem",,48)

	For Each objItem in colItems
	  OSVersion = Left(objItem.Version,3)

	  ' Stop errors from causing the script to fail. 
	  ' ProductType is not in the Windows 2000 or NT4 WMI
	  On Error Resume Next
	    OSProductType = Left(objItem.ProductType,2)
	
	    ' If there was an error accessing this property, we know the OS is Windows 2000 or NT4
	    if err.number <> 0 then
		' Set OSProductType to an arbitrary value.  It is only checked if the OSVersion is 5.2
		OSProductType = -1
 	    end if

	  On Error Goto 0  ' Allow errors to halt the script again

	Next
		
End Sub

'=======================================================================================
'
' Sub:	CheckAdminRights()
'  
'=======================================================================================
Sub CheckAdminRights

	Dim oReg
	Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")

	Const HKEY_LOCAL_MACHINE = &H80000002
	Const HKEY_CLASSES_ROOT  = &H80000000
	Const HKEY_CURRENT_USER  = &H80000001
	Const KEY_CREATE         = &H0020

	Dim bHasAccessRights: bHasAccessRights = False
	Dim bHasAccessRights2: bHasAccessRights2 = False
	Dim bHasAccessRights3: bHasAccessRights3 = False
	Dim bHasAccessRights4: bHasAccessRights4 = False

	oReg.CheckAccess HKEY_LOCAL_MACHINE, "SOFTWARE\" , KEY_CREATE, bHasAccessRights
	oReg.CheckAccess HKEY_LOCAL_MACHINE, "SYSTEM\" , KEY_CREATE, bHasAccessRights2
	oReg.CheckAccess HKEY_CURRENT_USER, "CONTROL PANEL\" , KEY_CREATE, bHasAccessRights3
	oReg.CheckAccess HKEY_CLASSES_ROOT, "CLSID\" , KEY_CREATE, bHasAccessRights4

	If ((bHasAccessRights = False) Or (bHasAccessRights2 = False) or (bHasAccessRights3 = False) or (bHasAccessRights4 = False)) Then
	  WScript.echo "Save/Restore Script requires Administrative Rights.  Please log in as an Administrator and try again.  In Windows* Vista, this script must be run as the built-in Administrator.  Other users with administrative rights do not have sufficient rights to execute this script.", 0, "Intel(R) Save/Restore Script"
	  WScript.Quit(0)
	End If

End Sub

'=======================================================================================
'
' Sub:		SaveOemCustomizeableSetting()
' Description:	Saves the current value of OEMCustomizeable in the NCS2 dmix key
'  
'=======================================================================================
function SaveOemCustomizeableSetting()
	dim regAccess
	dim strKeyPath, strValueName, dwValue
	dim retValue
	
	const KEY_QUERY_VALUE 	= &H0001
	const HKEY_LOCAL_MACHINE = &H80000002

	set regAccess = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")

	strKeyPath = "SOFTWARE\Intel\Network_Services\NCS2"
	strValueName = "OEMCustomizeable"
	regAccess.GetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,dwValue

	retValue = "OEMCustomizeable=" & dwValue
	
	SaveOemCustomizeableSetting=retValue

end function

'=======================================================================================
'
' Sub:		RestoreOemCustomizeableSetting()
' Description:	Restores the saved value of OEMCustomizeable in the NCS2 dmix key
'  
'=======================================================================================
sub RestoreOemCustomizeableSetting(byVal setting)
	dim regAccess
	dim strKeyPath, strValueName, dwValue
	const HKEY_LOCAL_MACHINE = &H80000002

	if setting <> "" then 
		wscript.echo "Setting Oem Customizeable Value"
		set regAccess = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")
		
		strKeyPath = "SOFTWARE\Intel\Network_Services\NCS2"
		strValueName = "OEMCustomizeable"
		
		regAccess.SetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,setting
	end if
end sub

'=======================================================================================
'
' Sub:	PrintUsage()
'  
'=======================================================================================
Sub PrintUsage()
	WScript.Echo "Intel(R) SavResDx.vbs version 1.0 "
	WScript.Echo "Copyright (C) Intel, Inc. 2005. All rights reserved."
	WScript.Echo ""
	WScript.Echo "   Usage: SavResDX.vbs keywords default/settingsfile"
	WScript.Echo "   Keywords are required and are 'save' or 'restore' only."
	WScript.Echo "   Settings file can be the keyword 'default' or an explicit file name."
	WScript.Echo "   Settings filename must include the file path."
	WScript.Echo "   Default filename is WMIConf.txt, saved to the current directory."
	WScript.Echo "   Default filename is used if no settings filename is given or"
	WScript.Echo "   the keyword 'default' is used."  
End Sub

'=======================================================================================
'
' Sub:  SaveSettings(ByVal strFname)
'		Save Adapter's, team's and VLAN's info. and settings info. to a text file.
'		Save Adapter's compatiblity settings. 
'  
'=======================================================================================
Sub SaveSettings(byVal strFileName)	
	dim colNetDevicesPhysical,colNetDevicesLogical
	dim objNetDevicePhyObj,objFile,objNetDeviceLogObj
	dim wbemServices
	dim DeviceIndex

	'Create a configuration file
	If IsEmpty(CreateConfigFile(strFileName)) Then
		Exit sub
	Else
		Set objFile=CreateConfigFile(strFileName)
	End If
	objFile.WriteLine "*** NCS2 DMiX Save Data ***"
	objFile.WriteLine "*** Date " & Date & " Time " & Time() & "  ***"
	objFile.WriteLine "**********************************************"
	objFile.WriteLine ""	
	' Save the OEMCustomeizable Setting for ViiV
	objFile.WriteLine SaveOemCustomizeableSetting()
	
'	Set wbemServices = GetObject("winmgmts://./root/IntelNcs2")  
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
	
	'Get all instances from IANet_PhysicalEthernetAdapter for adapters
	
	Set colNetDevicesPhysical = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter") 
	'Save Adapters 
	DeviceIndex=1	

	For each objNetDevicePhyObj in colNetDevicesPhysical
		'Save settings for only Intel adapters by checking for Non-Intel and disabled adapters
'		If (StrComp(Mid(objNetDevicePhyObj.Caption, 1, 13), "Intel(R)", vbTextCompare)) = 0 AND (objNetDevicePhyObj.StatusInfo= 3) then	
		If(InStr(1,objNetDevicePhyObj.Caption, "Intel(R)", 1) <> 0) AND (objNetDevicePhyObj.StatusInfo= 3) then				
			'Save Adapter specific info			
				objFile.WriteBlankLines(1)				
				SaveAdapterInfo objFile, objNetDevicePhyObj, DeviceIndex				
				'Save Express Team info for initiator only
				If objNetDevicePhyObj.ExpressTeaming=1 Then
					SaveExpressTeamInfo objFile, objNetDevicePhyObj, wbemServices			
				End if
				SaveAdvancedSettings objFile, objNetDevicePhyObj, wbemServices
				SaveVlanSettings objFile, objNetDevicePhyObj, wbemServices
				DeviceIndex=DeviceIndex + 1
		End if
	Next
	
	objFile.WriteBlankLines(1)
	
	'Get all instances from IANet_LogicalEthernetAdapter for teams
	Set colNetDevicesLogical = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter") 

	' SCR 50668 Fix:  Without ANS installed, the IANet_LogicalEthernetAdapter class
	' Is not exposed in the WMI, causing the for each loop below to fail.  Since 
	' isNull() and isEmpty() are not reflecting when IANet_LogicalEthernetAdapter
	' is not there, it was needed to be done like this.  
	
	' Turn on error handling (script does not halt on errors)
	on Error Resume Next
		For each objNetDeviceLogObj in colNetDevicesLogical

			' check if there was an error accessing the Logical Adapter collection
			' if not, get the ANS information
			if err.number = 0 then
				'Save Team specific info
				SaveTeamInfo objFile, objNetDeviceLogObj, DeviceIndex, wbemServices			
				SaveTeamAdvancedSettings objFile,objNetDeviceLogObj,wbemServices
				SaveVlanSettings objFile, objNetDeviceLogObj, wbemServices
				DeviceIndex=DeviceIndex + 1
				objFile.WriteBlankLines(1)	
			end if
		Next

	' Turn off error handling (script halts on errors again)
	on Error Goto 0
	
	objFile.WriteBlankLines(1)
	
	objFile.close
	Wscript.Echo "Saving done!"

	
	SaveStaticIPSettings(IPFilePath)
	
End Sub

'****************************************************************************
Private Function SaveAdapterInfo(objFile,objAdapter,DeviceIndex)
	dim LastCapIndex
	dim index,bFound 
	bFound = False
	
	LastCapIndex=Ubound(objAdapter.Capabilities)
	'objFile.WriteLine "Adapter Name=" & objAdapter.Caption 20/2/2004
	objFile.WriteLine "Adapter Name=" & objAdapter.OriginalDisplayName

	If bIsUpgrade Then
		'Save MAC address in config file for DMiX-to-DMiX upgrade scenarios only.
		objFile.WriteLine "Adapter PCIDeviceID=" & objAdapter.PermanentAddress
	Else
		objFile.WriteLine "Adapter PCIDeviceID=" & objAdapter.PCIDeviceID
	End if

	objFile.WriteLine "Adapter Index=" & DeviceIndex
	objFile.WriteLine "Private Description="
	objFile.Write "Adapter Capabilities=" 
	
	For index = 0 to LastCapIndex-1
		objFile.Write objAdapter.Capabilities(index) 
		objFile.Write ","
		if( objAdapter.Capabilities(index) = 50) then			
			bFound = True		
		End if	
	Next
	if bFound then
		isPowerManagementSupported = True
	Else
		isPowerManagementSupported = False	
	End if
	objFile.WriteLine objAdapter.Capabilities(LastCapIndex)
	objFile.WriteLine "Description=" & objAdapter.Description
End Function

'*****************************************************************************
Private Function CreateConfigFile(byVal strFileName)
	dim fso
	dim file
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set file=fso.CreateTextFile(strFileName,True)
	Set CreateConfigFile=file
End Function

'*****************************************************************************
Private Function SaveAdvancedSettings(objFile,objAdapter,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj,OutParam

	strQuery = "ASSOCIATORS OF {" & objAdapter.Path_.Path & "} WHERE ResultClass = IANet_AdapterSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
				
	For Each IANet_Obj In IANet_config
		'Check for ExpressTeaming setting, and skip saving it if it exists.
		If (StrComp(Mid(IANet_Obj.Caption, 1, 14), "ExpressTeaming", vbTextCompare) <>0) Then 	'For avoiding Express Team Info
			If ( Is_GVRP_GMRP_Setting(IANet_Obj.Caption) = FALSE ) Then  ' don't save GVRP or GMRP settings
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption 			
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			End If
		End If			

	Next	
		
	'Power Saver

	if (isPowerManagementSupported = True) Then	
		' Some older versions of DMXI do not support all these power 
		' management options so we need to move on if there is a failure
		on error resume next

		Set OutParam = objAdapter.ExecMethod_("GetPowerUsageOptions")
		if isnull(OutParam.AutoPowerSaveModeEnabled) Then	
		else
			objFile.WriteLine"setting Name=AutoPowerSaveModeEnabled"
    			objFile.WriteLine"setting Current Value=" & OutParam.AutoPowerSaveModeEnabled
    			objFile.WriteLine"setting Description=AutoPowerSaveModeEnabled"
    		End If
		if isnull(OutParam.ReduceSpeedOnPowerDown) Then	
		else
			objFile.WriteLine"setting Name=ReduceSpeedOnPowerDown"
    			objFile.WriteLine"setting Current Value=" & OutParam.ReduceSpeedOnPowerDown
    			objFile.WriteLine"setting Description=ReduceSpeedOnPowerDown"
    		End If
		if isnull(OutParam.SmartPowerDown)Then    
		else    		   
	   		objFile.WriteLine"setting Name=SPDEnabled"
			objFile.WriteLine"setting Current Value=" & OutParam.SmartPowerDown
			objFile.WriteLine"setting Description=SmartPowerDown"
		End If
		if isnull(OutParam.SavePowerNowEnabled) Then	
		else
			objFile.WriteLine"setting Name=SavePowerNowEnabled"		
			objFile.WriteLine"setting Current Value=" & OutParam.SavePowerNowEnabled
			objFile.WriteLine"setting Description=SavePowerNowEnabled"
		End If
		if isnull(OutParam.EnhancedASPMPowerSaver) Then	
		else
			objFile.WriteLine"setting Name=EnhancedASPMPowerSaver"		
			objFile.WriteLine"setting Current Value=" & OutParam.EnhancedASPMPowerSaver
			objFile.WriteLine"setting Description=EnhancedASPMPowerSaver"
		End If

		' Turn error checking back on
		on error goto 0
		
	End If
End Function

'*****************************************************************************
Private Function SaveTeamInfo(objFile,objNetDeviceLogObj,DeviceIndex,wbemServices)
 	dim colTeamedAdapters,colTeamedMemberAdapter,colTeam
 	dim TeamedAdapter,TeamedMemberAdapter,objTeam    
    	dim strQuery
 

    'Access the same Team from IANet_TeamOfAdapters 
    strQuery="ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} where ResultRole=SameElement"
	Set colTeam = wbemServices.ExecQuery(strQuery)
	
    For Each objTeam In colTeam 'only one team in this collection    	
	    	
	    	' The team prefix to the name has now been localized so we can no longer assume the prefix is "TEAM : "
	    	' Get the localized prefix from the MOF file to extract the user's name
	    	objFile.WriteLine "Team Name=" & ExtractTeamPrefixFromTeamName(objTeam.Caption)
	    	
		objFile.WriteLine "Description=" & objTeam.Description
		objFile.WriteLine "Team Settings Index=" & DeviceIndex				
		'Get Team Mode and Adapter count
		objFile.WriteLine "Team Type=" & objTeam.TeamingMode
		
		objFile.WriteLine "Adapter Count=" & objTeam.AdapterCount	
		'MFO Enabled
		ManageabilityTeam objFile,objNetDeviceLogObj,wbemServices,objTeam

		'Access Members of this Team
		
		strQuery="ASSOCIATORS OF {" & objTeam.Path_.Path & "} where ResultRole=PartComponent"   
		Set colTeamedAdapters = wbemServices.ExecQuery(strQuery) 		
		For Each TeamedAdapter In colTeamedAdapters
		'	'objFile.WriteLine "Member Adapter="&TeamedAdapter.Caption	
			objFile.WriteLine "Member Adapter="&TeamedAdapter.OriginalDisplayName
			If bIsUpgrade Then
				objFile.WriteLine "Member PCIDeviceID="&TeamedAdapter.PermanentAddress	'Save MAC address in config file for upgrade scenarios only.
			Else
				objFile.WriteLine "Member PCIDeviceID="&TeamedAdapter.PCIDeviceID
			End if

			'Get Priority settings for this member adapter
			strQuery="REFERENCES OF {" & TeamedAdapter.Path_.Path & "} where ResultClass=IANet_TeamedMemberAdapter"
			Set colTeamedMemberAdapter= wbemServices.ExecQuery(strQuery)
			For Each TeamedMemberAdapter In colTeamedMemberAdapter
				objFile.WriteLine "-Preferred Priority Setting="&TeamedMemberAdapter.AdapterFunction
				' parse out just the device ID of the TEAM and ADAPTER
				'objFile.WriteLine "-Group Comp Setting=" + Mid(TeamedMemberAdapter.GroupComponent,(instr(TeamedMemberAdapter.GroupComponent,"{")+1),36)
				objFile.WriteLine "-Part Comp Setting=" + Mid(TeamedMemberAdapter.PartComponent,(instr(TeamedMemberAdapter.PartComponent,"{")+1),36)
			Next	
		Next	
	Next
End Function		

'///////////////////////////////////////////////////////////////////////////////
'// FUNCTION NAME	: ExtractTeamPrefixFromTeamName
'//
'// DESCRIPTION	    	: Call this function to determine what is the spelling						
'//			: of the localized team prefix.  Then extract this 
'//			: portion from the string passed in.  
'// PARAMETERS		: String - value returned from IANET_TeamOfAdapters.Caption 
'// RETURN		: String - the caption without the team prefix
'///////////////////////////////////////////////////////////////////////////////
Private Function ExtractTeamPrefixFromTeamName(szWholeTeamName)
'
	'Wscript.echo "Entering - ExtractTeamPrefixFromTeamName - input ->" + szWholeTeamName + "<-"
	On Error Resume Next
	Err.Clear
	Const wbemFlagUseAmendedQualifiers = &h20000
	Dim wbemServices
	Dim ObjClass
	Dim ColProperties
	Dim ObjProperties
	Dim ColQualifiers
	Dim ObjQualifiers
	Dim szTeamPrefix : szTeamPrefix = ""
	
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
	Set ObjClass = wbemServices.Get("IANet_TeamOfAdapters",wbemFlagUseAmendedQualifiers)
    
    	Set ColProperties = ObjClass.Properties_
    	Set ObjProperties = ColProperties.Item("TeamPrefix")
    	If Err Then
		'Wscript.echo "TeamPrefix not found"
		If (InStr(szWholeTeamName,"TEAM : ")) Then
			szWholeTeamName = Mid(szWholeTeamName,(Len("TEAM : ") + 1))
		End If
		'Wscript.echo "Exiting - ExtractTeamPrefixFromTeamName - output ->" + szWholeTeamName + "<-"
    		ExtractTeamPrefixFromTeamName = szWholeTeamName
		exit function
    	End If 
    	Err.Clear
    	
    	Set ColQualifiers = ObjProperties.Qualifiers_
    	Set ObjQualifiers = ColQualifiers.Item("Values")
    	If Err Then
		'Wscript.echo "Values not found"
		If (InStr(szWholeTeamName,"TEAM : ")) Then
			szWholeTeamName = Mid(szWholeTeamName,(Len("TEAM : ") + 1))
		End If
		'Wscript.echo "Exiting - ExtractTeamPrefixFromTeamName - output ->" + szWholeTeamName + "<-"
    		ExtractTeamPrefixFromTeamName = szWholeTeamName
		exit function
    	End If 
  
	If VarType(ObjQualifiers.Value) = (vbVariant + vbArray) Then
		szTeamPrefix = ObjQualifiers.Value(LBound(ObjQualifiers.Value))
	Else
		szTeamPrefix = ObjQualifiers.Value
	End If
	
	If (Len(szTeamPrefix) < 1)Then
		szTeamPrefix = "TEAM : "
	End If
	
	'Wscript.echo "Team prefix is ->" + szTeamPrefix + "<-"
	
	If (InStr(szWholeTeamName,szTeamPrefix)) Then
		szWholeTeamName = Mid(szWholeTeamName,(Len(szTeamPrefix) + 1))	
	ElseIf (InStr(szWholeTeamName,"TEAM : ")) Then
		szWholeTeamName = Mid(szWholeTeamName,(Len("TEAM : ") + 1))
	End If
	
	'Wscript.echo "Exiting - ExtractTeamPrefixFromTeamName - output ->" + szWholeTeamName + "<-"
	
	ExtractTeamPrefixFromTeamName = szWholeTeamName
'
End Function

'*****************************************************************************
Private Function SaveTeamAdvancedSettings(objFile,objNetDevicelogObj,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj

	strQuery = "ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} WHERE ResultClass = IANet_TeamSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)

		
		For Each IANet_Obj In IANet_config
			If ( Is_GVRP_GMRP_Setting(IANet_Obj.Caption) = FALSE ) Then  ' don't save GVRP or GMRP settings
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			End If
		Next	
End Function

'*****************************************************************************
Private Function SaveVlanSettings(objFile,objAdapter,wbemServices)
	dim strQuery
	dim IANet_802dot1VLANService,IANet_VLANSet
	dim IANet_802dot1VLANObj,IANet_VLANObj

		strQuery = "ASSOCIATORS OF {" & objAdapter.Path_.Path & "} WHERE ResultClass = IANet_802dot1QVLANService"
		Set IANet_802dot1VLANService = wbemServices.ExecQuery(strQuery)
		If IANet_802dot1VLANService.Count <> 0 Then 
			For Each IANet_802dot1VLANObj In IANet_802dot1VLANService	      
				strQuery = "ASSOCIATORS OF {" & IANet_802dot1VLANObj.Path_.Path & "} WHERE ResultClass = IANet_VLAN"
				Set IANet_VLANSet = wbemServices.ExecQuery(strQuery)
				If IANet_VLANSet.Count > 0 Then
					For Each IANet_VLANObj In IANet_VLANSet
						objFile.WriteLine "VLAN Name=" & IANet_VLANObj.VLANName
						objFile.WriteLine "VLAN Id=" & IANet_VLANObj.VLANNumber
						If(IANet_VLANObj.ParentType = 0) Then 'If parent is adapter,then only save vlan settings
							SaveVLANAdvancedSettingsForAdapter objFile,IANet_VLANObj,wbemServices	
						'Elseif(IANet_VLANObj.ParentType = 1) Then  only saves GVRP + GMRP settings - skip
						'	SaveVLANAdvancedSettingsForTeam objFile,IANet_VLANObj,wbemServices								
						End if
					Next
				End If
			Next
		End If
End Function

	
'*****************************************************************************
Private Function SaveVLANAdvancedSettingsForAdapter(objFile,objNetDeviceLogObj,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj
	strQuery = "ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} WHERE ResultClass = IANet_VLANSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
	
		
		For Each IANet_Obj In IANet_config
			If ( Is_GVRP_GMRP_Setting(IANet_Obj.Caption) = FALSE ) Then  ' don't save GVRP or GMRP settings
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			End If
		Next	
End Function

'*****************************************************************************
'*****************************************************************************
Private Function SaveVLANAdvancedSettingsForTeam(objFile,objNetDeviceLogObj,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj
	strQuery = "ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} WHERE ResultClass = IANet_VLANSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
	
		
		For Each IANet_Obj In IANet_config
			if(Strcomp(Mid(IANet_Obj.Caption,1,4),"GMRP") = 0) Then
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			Elseif(Strcomp(Mid(IANet_Obj.Caption,1,4),"GVRP") = 0) Then
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			End if
		Next	
End Function

'*****************************************************************************



'=====================================================================================
'
' Sub:	RestoreSettings(ByVal strFname)
'		Call subs to read file to get all the info. about adapter, Team and VLANs.
'		If there are the same number of adapters as settings then 
'		it will apply the saved settings, as long as the adapters are the same type.  
'		If the adapter is a different type, compatibility
'		is determined by local network speed.  Then applicable settings are applied.
'		If number of settings and adapters are mismatched, user is prompted for selection
'   
'=====================================================================================
Sub RestoreSettings(ByVal strFname)
	Dim strTeamName

	bError = FALSE

	
	'Read File and assign found values to Teams() and Adapters()
	ReadFile(strFname)
	If bError = FALSE Then
	'Set the OemCustomizeable registry setting
	RestoreOemCustomizeableSetting(strOEMCustomizeableValue)
	'Remove any existing Teams and VLANs.
	Remove()
	'Create single session to make changes..
	CreateSessions() 
	ValidateAdapters()

	on error resume next
	Set test = wbemServices.Get("IANet_LogicalEthernetAdapter")

	if err < 0  then 
		wscript.echo "Unable to enumerate Advanced Network Service information, ANS might not be present on system"
		wscript.echo "Teams and VLAN information contained in the configuration file will not attempt to be restored."
		bNoAns = true
	end if

	on error goto 0 

	'Cycle as many times as adapter sets in file, check selection and compatibility, then apply
		For Each AdapterObj in AdapterSets
				For index = 0 to (totalAdapters - 1)
					strAdapterName = Adapters(index, 1, 0)			'Adapter Name
					strAdapterPCIDeviceID = Adapters(index, 1, 1)	'Adapter PCIDeviceID or PermanentAddress
					strCapabilities = Adapters(index, 2, 0)			'Capabilities
					strOrgDispName = Adapters(index, 2, 1)			'Original Display Name
					strSettingsIndex = Adapters(index, 3, 0)		'Setting Index
				
					If bMisMatch = TRUE Then
						CheckSelected strSettingsIndex
						If bUserInput = TRUE Then
							If bSelected = TRUE Then
								If strAdapterName = AdapterObj.Caption Then	
									If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R)", 1) <> 0) Then 																				
										ApplyAdapterSettings(strSettingsIndex)										
										Exit For
									End If
								End If
							End If
						End If
					Else
						If strAdapterName = AdapterObj.Caption Then
							If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R)", 1) <> 0) Then 
								ApplyAdapterSettings(strSettingsIndex)																			
								Exit For
							End If
						Elseif (bIsUpgrade = True) AND (strAdapterPCIDeviceID = AdapterObj.PermanentAddress) AND (AdapterObj.PermanentAddress <> "") Then
							If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R)", 1) <> 0) Then 
								ApplyAdapterSettings(strSettingsIndex)																			
								Exit For
							End If
						Elseif (bIsUpgrade = False) AND (strAdapterPCIDeviceID = AdapterObj.PCIDeviceID) AND (AdapterObj.PCIDeviceID <> "") Then
							If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R)", 1) <> 0) Then 
								ApplyAdapterSettings(strSettingsIndex)																			
								Exit For
							End If
						End If
					End If
				Next				
		Next	
		ExecApply wbemServices, strNetSerObjPath, SessionObject	'SCR 37163

		if bNoAns<>true then
			For index = 0 to (totalTeams - 1)
				strSettingsIndex = Teams(index, 1, 2)
				strTeamName = Teams(index, 0, 0)
				If bMisMatch = TRUE Then
					'Sets bSelected
					CheckSelected strSettingsIndex
					If bSelected = TRUE Then					
						ApplyTeamSettings(strSettingsIndex)					
					End If			
				Else
					ApplyTeamSettings(strSettingsIndex)								
				End If
			Next
		end if
		
		If bNewTeam  = TRUE Then
			WScript.Echo "New team(s) were created based on config file"
		ElseIf bModified = TRUE  Then
			WScript.Echo "New Settings were applied!"
		ElseIf bUserInput = TRUE Then
			WScript.Echo "No new settings were applied.  Any existing teams were deleted."
		Else
			WScript.Echo "No new settings were applied.  Any existing teams were deleted."
		End If

	ElseIf bError = TRUE Then
		Exit Sub
	End If

	ReleaseHandle wbemServices, strNetSerObjPath, SessionObject 

	'SCR:46569
	'Restore Express Teams in DMiX
	CreateSessions()
	CreateExpressTeam()
	If bExpressTeam = TRUE Then
		ExecApply wbemServices, strNetSerObjPath, SessionObject
		WScript.Echo "Express team(s) were restored based on config file"
	End if
	ReleaseHandle wbemServices, strNetSerObjPath, SessionObject 

	RestoreStaticIPSettings(IPFilePath)

End Sub
	
'=====================================================================================
'
' Sub:	Sub ExecApply(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
'  
'=====================================================================================
Sub ExecApply(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
	Dim StdOut,oReg,strComputer,strKeyPath,strValueName,strValue
	
	WScript.Echo "Executing apply..."	
	Set NetServiceObject = wbemServices.Get(strNetSerObjPath)
	Set FinalTargetobj = NetServiceObject.ExecMethod_("Apply", SessionObject)
	'WScript.Echo "FinalTargetobj.FollowupAction" & FinalTargetobj.FollowupAction
	if FinalTargetobj.FollowupAction = 1 Then
		WScript.Echo "FinalTargetobj.FollowupAction" & FinalTargetobj.FollowupAction
		strComputer = "."
		Set StdOut = WScript.StdOut
		Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_ 
		strComputer & "\root\default:StdRegProv")
		strKeyPath ="SOFTWARE\INTEL\Network_Services\DMIX"
		strValueName = "RebootReq"
		strValue = "1"
		oReg.SetStringValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,strValue
	End if
End Sub

'=====================================================================================
'
' Sub:	Sub ReleaseHandle(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
'  
'=====================================================================================
Sub ReleaseHandle(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
	WScript.Echo "Releasing Session Handle"
	Set NetServiceObject = wbemServices.Get(strNetSerObjPath)
	Set FinalTargetobj = NetServiceObject.ExecMethod_("Apply", SessionObject)
End Sub

'==================================================================================================
'
' CreateSessions()
' Create sessions to make settings changes
'
'==================================================================================================

Sub CreateSessions()
	Dim IANet_NetServiceClassDescription,cstring
	Dim Method 
	Dim ServiceObject,TempObj
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	' SCR fix for 38688 and 39528
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
	Set IANet_NetServiceClassDescription = wbemServices.Get("IANet_NetService")
	Set SessionObject = IANet_NetServiceClassDescription.Methods_.Item("Apply").InParameters.SpawnInstance_()  
	
	Set SValueSet = CreateObject("WbemScripting.SWbemNamedValueSet")
	Set NetServiceSet = wbemServices.InstancesOf("IANet_NetService")

	For Each NetServiceObject In NetServiceSet	
		strNetSerObjPath = NetServiceObject.Path_.Path	
		Set Method = NetServiceObject.Methods_("BeginApply")			' Save the path for later use
		Set ServiceObject = NetServiceObject.ExecMethod_("BeginApply")
		If ServiceObject.returnValue = 0 Then
			cstring = ServiceObject.ClientSetHandle
		End If
	
	Next
	
	SValueSet.Add "ClientSetId", cstring
	SessionObject.ClientSetHandle = cstring	

	Set AdapterSets = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter",,SValueSet)	

End Sub

'======================================================================================
'
' Sub ValidateInput(ByVal strInput)
'Validate input by removing any spaces or periods in strInput, returns strChoices
'========================================================================================
Sub ValidateInput(ByVal strInput)
	Dim i, ii, arrChoices
	arrChoices = Split(strInput, ",")
	For i = 0 to Ubound(arrChoices)
		arrChoices(i) = Trim(arrChoices(i))
		If Right(arrChoices(i), 1) = "." Then
			arrChoices(i) = Replace(arrChoices(i), ".", "")
		End If
	Next
	strChoices = Join(arrChoices, ",")
End Sub

'=================================================================================================
'
' Sub ReadFile(ByVal strFname)
' Read File and assign found values to Adapters() and Teams() arrays
'
'=================================================================================================
Sub ReadFile(ByVal strFname)
	Dim v, i, ii, x, fso, strAdapterName ,w
	Dim strAdapterCaps, strNewAdapterName, strPCIDeviceID, strAdapterIndex 
	Dim strCapabilities, strSettingsSet, arrSettingsSets
	Dim strIsDefault, ts, strLine, z, numVLANS, numTVLANS
	dim firstVlanIndex : firstVlanIndex = -1	
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FileExists (strFname) <> True Then
		Wscript.Echo "The configuration file can not be found or is"
		Wscript.Echo "not in the same directory as SavResDX.vbs."
		WScript.Echo "Try using full pathname to the configuration file."
		bError = TRUE
		Exit Sub
	Else
	
		' Array Adapters holds all the info. about the adapter's and related VLANs info.
		' Adapters( , 0, 0) is a flag of Adapter's existence
		' Adapters( , 0, 1) is a flag for setting having been applied
		' Adapters( , 0, 2) is Number of VLANS on Adapter
		' Adapters( , 1, 0) is Adapter's Name
		' Adapters( , 1, 1) is Adapter's PCIDeviceID or PermanentAddress
		' Adapters( , 2, 0) is Adapter's Capabilities
		' Adapters( , 2, 1) is Adapter's Original Display Name (for Express Teaming)
		' Adapters( , 3, 0) is Settings Index, for selecting settings sets
		' Adapters( , 3, 1) is Settings Default, "TRUE" or "FALSE" for selecting settings sets
		' Adapters( , 4, 0) is Adapter's Setting Name 
		' Adapters( , 4, 1) is Adapter's Setting value
		'
		' Adapters( , x, 0) is Keyword "VLAN", any elements after this keyword are VLAN's setting name and value 
		
		Redim Adapters(maxAdapterTeam, maxSettings, 5)  
		
		' Array Teams holds all the info. about the Team's and related VLANs info.
		' Teams( , 0, 0) is Team's Name
		' Teams( , 0, 1) is a flag for setting having been applied
		' Teams( , 0, 2) is number of VLANS on Team
		' Teams( , 1, 0) is Team's Type
		' Teams( , 1, 1) is Team's Adapter Count
		' Teams( , 1, 2) is Teams Settings Index for user selection
		
		' Teams( , 2, 0) is keyword "MemberAdapter", 
		' Teams( , 2, 1) is Member adapter's caption
		' Teams( , 2, 2) is Member adapter's flag for client(0) or server(1) property
		' Teams( , 2, 3) is Member adapter's Preferred Priority Setting
		' Teams( , 2, 4) is Member adapter's flag for "Already Added to Team" (1 or 0)
		' Teams( , 2, 5) is Member adapter's PCIDeviceID or PermanentAddress
		'
		' Teams( , x, 0) is keyword "MemberAdapter", 
		' Teams( , x, 1) is related adapter's caption
		' Teams( , x+1, 0) is Teams's Setting Name; Teams( , x+1, 1) is team's Setting value
		' Teams( , y, 0) is Keyword "VLAN", any elements after this keyword are VLAN's setting name and value 
		Redim Teams(maxAdapterTeam, maxSettings, 10)  

		totalAdapters = 0
		totalTeams = 0

		' Read the text file and save all the info. to two arrays - Adapters() & Teams()
		Set ts = fso.OpenTextFile(strFname, 1)
		ii = 0
		v = 0
		x = 0
		w=0
		Do Until ts.AtEndOfStream
			
			
			ReDim Preserve arrPrivDesc(v + 1)
			ReDim Preserve arrTeamPrivDesc(x + 1)
			strLine = ts.ReadLine()
			If StrComp(Mid(strLine, 1, 13), "Adapter Name=", vbTextCompare) = 0 Then
				numVLANS = 0  
				strNewAdapterName = Mid(strLine, 14)
				strLine = ts.ReadLine()
				If StrComp(Mid(strLine, 1, 20), "Adapter PCIDeviceID=", vbTextCompare) = 0 Then
					strPCIDeviceID = Mid(strLine, 21)
					strLine = ts.ReadLine()
				End If
				If StrComp(Mid(strLine, 1, 14), "Adapter Index=", vbTextCompare) = 0 Then
					strAdapterIndex = Mid(strLine, 15)
					strLine = ts.ReadLine()	
				End If
				If StrComp(Mid(strLine, 1, 20), "Private Description=", vbTextCompare) = 0 Then
					arrPrivDesc(v) = Mid(strLine, 21) 
					strLine = ts.ReadLine()
					v = v + 1
				End If
				If StrComp(Mid(strLine, 1, 21), "Adapter Capabilities=", vbTextCompare) = 0 Then
					strCapabilities =Mid(strLine, 22)
					strLine = ts.ReadLine()
				End If
				strLine = ts.ReadLine()		'Skip Description line.
				If StrComp(Mid(strLine, 1, 22), "Original Display Name=", vbTextCompare) = 0 Then
					strOrgDispName = Mid(strLine, 23)	'For Express Teaming
					strLine = ts.ReadLine()
				End If
				
				'Assign found values to array"
				Adapters(totalAdapters, 1, 0) = strNewAdapterName
				Adapters(totalAdapters, 1, 1) = strPCIDeviceID
				Adapters(totalAdapters, 2, 0) = strCapabilities
				Adapters(totalAdapters, 2, 1) = strOrgDispName		'For Express Teaming
 		   		Adapters(totalAdapters, 3, 0) = strAdapterIndex              
				Adapters(totalAdapters, 3, 1) = strIsDefault
				
				'assigning settings values"
				i = 4
				
				'SCR 40856
				'strLine = ts.ReadLine() 
				Do while StrComp(strLine, "", vbTextCompare) <> 0
					If StrComp(Mid(strLine, 1, 13), "Setting Name=", vbTextCompare) = 0 Then
						If ( Is_GVRP_GMRP_Setting(strLine) = FALSE ) Then
							Adapters(totalAdapters, i, 0) = Mid(strLine, 14)	'Setting Name
							strLine = ts.ReadLine()
							Adapters(totalAdapters, i, 1) = Mid(strLine, 23)	'Setting Value
							i = i + 1
						Else
							strLine = ts.ReadLine() 'skip the next line if GVRP or GMRP
						End If
						strLine = ts.ReadLine()			' Skip the description
						
					ElseIf StrComp(Mid(strLine, 1, 10), "VLAN Name=", vbTextCompare) = 0 Then
						Do while StrComp(strLine, "", vbTextCompare) <> 0
							Adapters(totalAdapters, i, 0) = "VLAN"				'Set up keyword for searching VLAN later
							numVLANS = numVLANS + 1
							Adapters(totalAdapters, 0, 2) = numVLANS
							Adapters(totalAdapters, i+1, 0) = Mid(strLine, 11)	'VLAN Name
							strLine = ts.ReadLine()
							Adapters(totalAdapters, i+2, 0) = Mid(strLine, 9)	'VLAN ID
							i = i + 3
							strLine = ts.ReadLine()
							Do While StrComp(Mid(strLine, 1, 10), "VLAN Name=", vbTextCompare) <> 0
								If StrComp(Mid(strLine, 1, 13), "Setting Name=", vbTextCompare) = 0 Then
									If ( Is_GVRP_GMRP_Setting(strLine) = FALSE ) Then
										Adapters(totalAdapters, i, 0) = Mid(strLine, 14)	'Setting Name
										strLine = ts.ReadLine()									
										Adapters(totalAdapters, i, 1) = Mid(strLine, 23)	'Setting Value
									Else
										strLine = ts.ReadLine() 'skip the next line if GVRP or GMRP
									End If
									strLine = ts.ReadLine()
								End If
								If strLine <> "" Then
									strLine = ts.ReadLine()
									i = i + 1
								Else
									Exit Do
								End If
							Loop
						Loop
					End If  
					If StrComp(strLine, "", vbTextCompare) <> 0 Then
						strLine = ts.ReadLine()
					End If
				Loop
				totalAdapters = totalAdapters + 1
			ElseIf StrComp(Mid(strLine, 1, 10), "Team Name=", vbTextCompare) = 0 Then
				Teams(totalTeams, 0, 0) = Mid(strLine, 11)
				strLine = ts.ReadLine()
				strLine = ts.ReadLine()	'Skip Description line
				If StrComp(Mid(strLine, 1, 20), "Team Settings Index=", vbTextCompare) = 0 Then
					Teams(totalTeams, 1, 2) = Mid(strLine, 21)
					strLine = ts.ReadLine()
				End If
				If StrComp(Mid(strLine, 1, 10), "Team Type=", vbTextCompare) = 0 Then
					Teams(totalTeams, 1, 0) = Mid(strLine, 11)
					strLine = ts.ReadLine()
				End If
				If StrComp(Mid(strLine, 1, 14), "Adapter Count=", vbTextCompare) = 0 Then
					Teams(totalTeams, 1, 1) = Mid(strLine, 15)
					strLine = ts.ReadLine()
				End If			
			
				'Added for MFO on 17th Feb
				If StrComp(Mid(strLine, 1, 11), "MFOEnabled=", vbTextCompare) = 0 Then
					'bMFOEnabled =Mid(strLine, 12)
					Teams(totalTeams, 1, 3)=Mid(strLine, 12)						
					strLine = ts.ReadLine()					
				Else
					Teams(totalTeams, 1, 3)=0
				End If 
				
				If StrComp(Mid(strLine, 1, 20), "Private Description=", vbTextCompare) = 0 Then
					arrTeamPrivDesc(x) = Mid(strLine, 21)
					x = x + 1
					strLine = ts.ReadLine()
				End If				
				i = 2				
				Dim AdapterInTeamOffset: AdapterInTeamOffset = 0
				Do While StrComp(Mid(strLine, 1, Len("Member Adapter=")), "Member Adapter=", vbTextCompare) = 0		

					TeamedMemberAdapterName(totalTeams, AdapterInTeamOffset) = Mid(strLine,(instr(strLine,"=") + 1))
					Dim vi
					Teams(totalTeams, i, 0) = "MemberAdapter"
					Teams(totalTeams, i, 1) = Mid(strLine, 16)

					strLine = ts.Readline()


					If StrComp(Mid(strLine, 1, Len("Member PCIDeviceID=")), "Member PCIDeviceID=", vbTextCompare) = 0 Then
						TeamedMemberAdapterPCIDeviceID(totalTeams, AdapterInTeamOffset) = Mid(strLine,(instr(strLine,"=") + 1))
						Teams(totalTeams, i, 5) = Mid(strLine, 20)			
						strLine = ts.Readline()
					End If
					If StrComp(Mid(strLine, 1, Len("-Preferred Priority Setting=")), "-Preferred Priority Setting=", vbTextCompare) = 0 Then
						TeamedMemberAdapterPreferredPrimarySetting(totalTeams, AdapterInTeamOffset) = Mid(strLine,(instr(strLine,"=") + 1))
						strLine = ts.ReadLine()
						Teams(totalTeams, i, 3) = Mid(strLine, 29)

					End If
					'If StrComp(Mid(strLine,1,Len("-Group Comp Setting=")),"-Group Comp Setting=",vbTextCompare) = 0 Then
					'	TeamedMemberAdapterGroupComponentSetting(totalTeams, AdapterInTeamOffset) = Mid(strLine,(instr(strLine,"=") + 1))
					'	strLine = ts.ReadLine()
					'End If
					If StrComp(Mid(strLine,1,Len("-Part Comp Setting=")),"-Part Comp Setting=",vbTextCompare) = 0 Then
						TeamedMemberAdapterPartComponentSetting(totalTeams, AdapterInTeamOffset) = Mid(strLine,(instr(strLine,"=") + 1))
						strLine = ts.ReadLine()
					End If					
					AdapterInTeamOffset = AdapterInTeamOffset + 1
					i = i + 1
				Loop
				
				Do while StrComp(strLine, "", vbTextCompare) <> 0					
					If StrComp(Mid(strLine, 1, 13), "Setting Name=", vbTextCompare) = 0 Then
						If ( Is_GVRP_GMRP_Setting(strLine) = FALSE ) Then
							Teams(totalTeams, i, 0) = Mid(strLine, 14)	'Setting Name
							strLine = ts.ReadLine()						
							Teams(totalTeams, i, 1) = Mid(strLine, 23)	'Setting Value						
							i = i + 1
						Else
							strLine = ts.ReadLine() 'skip the next line if GVRP or GMRP
						End If
						strLine = ts.ReadLine()						' Skip the description
						strLine = ts.ReadLine()
					ElseIf StrComp(Mid(strLine, 1, 10), "VLAN Name=", vbTextCompare) = 0 Then
						Teams(totalTeams, i, 0) = "VLAN"				'Set up keyword for searching VLAN later
						numTVLANS = numTVLANS + 1
						Teams(totalTeams, 0, 2) = numTVLANS
						Teams(totalTeams, i+1, 0) = Mid(strLine, 11)	'VLAN Name
						strLine = ts.ReadLine()
						Teams(totalTeams, i+2, 0) = Mid(strLine, 9)	'VLAN ID												
						i = i + 3
						strLine = ts.ReadLine()
					End If   
				Loop				
				totalTeams = totalTeams + 1
			ElseIf (StrComp(Mid(strLine, 1,17), "OEMCustomizeable=", vbTextCompare) = 0) Then
				strOEMCustomizeableValue = Mid(strLine, 18)
			End If
		Loop 'Until ts.AtEndOfStream
		ts.Close
	End If

	dim teamCount, vlanIndex, vlanCount
	dim teamVlanCount : teamVlanCount = 0

	if numTVLANS > 1 then
		for teamCount = 0 to totalTeams - 1
			teamVlanCount = 0
			for vlanIndex = 0 to 999
				if Teams(teamCount, vlanIndex, 0) = "VLAN" then
					teamVlanCount = teamVlanCount + 1
					vlanCount = vlanIndex
					if Teams(teamCount, vlanCount+2,0) = 0 AND teamVlanCount = 1 then
						dim swapName, swapId
						swapName = Teams(teamCount, vlanCount+1,0)
						swapId = Teams(teamCount, vlanCount+2,0)
						Teams(teamCount, vlanCount+1,0) = Teams(teamCount, vlanCount+3+1,0)
						Teams(teamCount, vlanCount+2,0) = Teams(teamCount, vlanCount+3+2,0) 
						Teams(teamCount, vlanCount+3+1,0) = swapName
						Teams(teamCount, vlanCount+3+2,0) = swapId
						bNewTeam = 0
						exit for
					end if	
				end if
			next
		next
	end if

End Sub

'=================================================================================================
'
' Sub ValidateAdapters()
' Check for installed adapter count, check against settings sets and get user input for mismatches.
' Sets strInput and strChoices
'
'=================================================================================================
Sub ValidateAdapters()
	Dim ii, iii, counter
	Dim strTemp, strTeamTemp, strCaptions, bFound
	
	bUserInput = FALSE
	existTotalAdapters = 0
	iii = 0
	'Count existing adapters and assign captions to array for user selection
	For Each AdapterObj In AdapterSets
		'Knock out Non-Intel and disabled adapters		
		If (InStr(1,AdapterObj.Caption, "Intel(R)", 1) <> 0) AND (AdapterObj.StatusInfo= 3) Then	'StatusInfo=3 (Enabled)
			ReDim Preserve Captions(iii + 1)
			existTotalAdapters = existTotalAdapters + 1
			Captions(iii) = AdapterObj.Caption
			iii = iii + 1	
		End If
	Next

	'Check existing adapters against settings sets and set bFound value accordingly
	For index = 0 to existTotalAdapters - 1
		For Each AdapterObj In AdapterSets
			If StrComp(AdapterObj.Caption, Adapters(index, 1, 0)) = 0 Then	'Adapter's Name
				bFound = True
			Elseif (bIsUpgrade = True) AND (StrComp(AdapterObj.PermanentAddress, Adapters(index, 1, 1)) = 0) AND (AdapterObj.PermanentAddress <> "") Then	'Adapter's PermanentAddress
				bFound = True
			Elseif (bIsUpgrade = False) AND (StrComp(AdapterObj.PCIDeviceID, Adapters(index, 1, 1)) = 0) AND (AdapterObj.PCIDeviceID <> "") Then			'Adapter's PCIDeviceID
				bFound = True
			End If
		Next
		If bFound = TRUE Then
			Adapters(index, 0, 0) = TRUE  'Adapter existence flag
		Else
			Adapters(index, 0, 0) = FALSE
		End If
	Next

	'Set string of adapter settings captions for user selection
	For ii = 0 to (totalAdapters - 1) 
		If Adapters(ii, 1, 0) <> "" Then
			strTemp = strTemp & Adapters(ii, 3, 0) & ". " & Adapters(ii, 1, 0) & (Chr(10) & Chr(13)) & "    Priv Desc:  " & arrPrivDesc(ii) & (Chr(10) & Chr(13))
			'<SettingsIndex> + ". " + <AdapterName> + 
			'Newline + 
			'Return + "Priv Desc:  " + <PrivateDesc> + 
			'Newline + 
			'Return
		End If
	Next
	'Set string of team descriptions for user selection
	For ii = 0 to (totalTeams - 1) 
		If Teams(ii, 0, 0) <> "" Then
			strTeamTemp = strTeamTemp & Teams(ii, 1, 2) & "." & Teams(ii, 0, 0) & (Chr(10) & Chr(13))
			counter = counter + 1
		End If
	Next

	'Set string of installed adapter captions for user selection
	For ii = 0 to Ubound(Captions)
		If Captions(ii) <> "" Then
			strCaptions = strCaptions & Captions(ii) & (Chr(10) & Chr(13))
		End If
	Next

	'Checking number of installed adapters vs. settings list, prompt user if the numbers don't match"
	bMisMatch = FALSE

'	If existTotalAdapters < (totalAdapters) Then
'		bMisMatch = TRUE
'		strInput = InputBox("There are " & existTotalAdapters & " installed adapters and " & totalAdapters & " adapter configuration sets contained in " & strFname & "."  & (Chr(10) & Chr(13)) & (Chr(10) & Chr(13)) & "Installed Adapters:  " & (Chr(10) & Chr(13)) & strCaptions & (Chr(10) & Chr(13)) & "Enter selections separated by commas, no spaces or periods."  & (Chr(10) & Chr(13)) &  "Adapter Sets-" & (Chr(10) & Chr(13)) & strTemp & (Chr(10) & Chr(13)) & "Team Sets-  " & (Chr(10) & Chr(13)) & strTeamTemp, "Mismatched Settings Sets")
'		If strInput <> "" Then
'			bUserInput = TRUE
'			ValidateInput strInput
'			
'		Else
'			strInput = InputBox("ERROR:  No Selection Entered!" & (Chr(10) & Chr(13)) & "User-defined descriptions are listed below.  Enter selections to apply, enter numbers separated by commas, no spaces or periods." & (Chr(10) & Chr(13)) & (Chr(10) & Chr(13)) & strTemp & (Chr(10) & Chr(13)) & strTeamTemp, "Enter Selection")
'			If strInput = "" Then
'				WScript.Echo "Script cannot continue without user selection."
'				bUserInput = FALSE
'				Exit Sub
'			Else
'				bUserInput = TRUE
'				ValidateInput strInput
'			End If
'		End If
'	ElseIf existTotalAdapters > totalAdapters Then		
'		bMisMatch = TRUE
'		WScript.Echo "There are not enough settings sets to apply to installed adapters.  Resave or check settings file."
'		bUserInput=FALSE
'		Exit Sub
'	End If
End Sub

'=================================================================================================
'
' Sub CheckSelected(ByVal strSettingsIndex)
' Check whether current settings set was selected by any user input, defaults to true if no mismatch
' Sets bSelected to True or False
'
'=================================================================================================
Sub CheckSelected(ByVal strSettingsIndex)
	bSelected = FALSE
	Dim iv, v, b
	If strChoices <> "" Then
		v = InStr(1, strChoices, ",", vbTextCompare)
		If v > 0 Then 
			iv = InStr(1, strChoices, strSettingsIndex, vbTextCompare)
			If iv > 0 Then
				bSelected = TRUE
			End If
		ElseIf (strChoices = strSettingsIndex) Then
				bSelected = TRUE
		End If
	ElseIf bMisMatch = FALSE Then
		bSelected = TRUE
	End If
End Sub

'==================================================================================================
'
' ApplyAdapterSettings(strSettingsIndex)
' Apply selected or all adapter settings and return status message to user
' 
'==================================================================================================
Sub ApplyAdapterSettings(ByVal strSettingsIndex)
	Dim IANet_configur, IANet_Obj, IANetSettingObj
	Dim IANet_802dot1VLANService, IANet_802dot1VLANObj
	Dim IANet_VLANconfigur, IANet_VLANObj, InParameterObj, OutParameterObj
	Dim TempVlanObject, VlanObjectSet,VlanObject, IANet_VLANConfObj,IANet_VLANSet
	Dim strSettingValue,bFoundPossibleValue,bVLAN 
	Dim strVLANName, strVLANID, FinalVlanObject
	Dim strQuery, strExistAdapterName, strExist
	Dim Dumbpath, i, ii, iii, iv, z, b, k, x, cstrPath, pos, intCurCount
	Dim TargetObjInstance, TargetObj, numVLANS,InParameter
	Const wbemFlagUseAmendedQualifiers = &h20000
	Const Temp = TRUE
	dim bAlreadyWarned' Used to tell the user that ANS might not be installed
	dim savedJValue : savedJValue = -1
	dim alreadyRestored
	
	bAlreadyWarned = false 
	Set Dumbpath = CreateObject("WbemScripting.SWbemObjectPath")
	'Setting applied flag to 0
	Adapters(index, 0, 1) = 0

	On Error Resume Next
	'Updating Adapter's settings by checking if selected and if not already applied
	strExistAdapterName = AdapterObj.Caption
	If (Adapters(index, 3, 0) = strSettingsIndex) Then
		WScript.Echo "Applying setting set " & strSettingsIndex & " to " & AdapterObj.Caption 
		If Adapters(index, 0, 0) Then	' Check if this adapter exists from previous validation sequence (Adapter Existence flag)
			strAdapterName = Adapters(index, 1, 0)			' Get Adapter's Name from this settings set 
			strSettingsIndex = Trim(strSettingsIndex)
		
			Adapters(index, 0, 1) = 1  ' Flag for setting being applied
			
			strQuery = "ASSOCIATORS OF {" & AdapterObj.Path_.Path & "} WHERE ResultClass = IANet_AdapterSetting"
			Set IANet_configur = wbemServices.ExecQuery(strQuery,,,SValueSet)			
							
				Dim j
				For j = 4 to maxSettings-1
					If StrComp(Adapters(index, j, 0), "", vbTextCompare) = 0 then   'Adapter setting Name
						Exit For						
						
					ElseIf bVLAN AND bNoAns <> true Then
						For x = 0 to numVLANS - 1
							if numVlans = 1 AND Adapters(index, j+1, 0) = 0 then
								wscript.echo "Unable to create an Untagged VLAN without a Tagged VLAN"								
								exit for
							end if

							if x = 0 AND Adapters(index, j+1, 0) = 0 then
								savedJValue = j
								wscript.echo "Untagged VLAN is first VLAN in the list, saving the index.  This VLAN will be restored last."
							end if
							
							Set TempVlanObject = wbemServices.Get("IANet_802dot1QVLANService", ,SValueSet)
							Set InParameterObj = TempVlanObject.Methods_.Item("CreateVLAN").InParameters.SpawnInstance_()
							InParameterObj.Name = Adapters(index, j, 0)						
							InParameterObj.VLANNumber = Adapters(index, j+1, 0)						
							strQuery = "ASSOCIATORS OF {" & AdapterObj.Path_.Path & "} WHERE ResultClass = IANet_802dot1QVLANService"
							Set VlanObjectSet = wbemServices.ExecQuery(strQuery,,,SValueSet)
							
							For Each VlanObject In VlanObjectSet
								Set FinalVlanObject = wbemServices.Get(VlanObject.Path_.Path, ,SValueSet)					
								Set OutParameterObj = FinalVlanObject.ExecMethod_("CreateVLAN", InParameterObj, 0, SValueSet)
								bModified = TRUE
								Exit For
							Next
							if NOT (x = 0 AND Adapters(index, j+1, 0) = 0) then
								WSCript.Echo "updating VLAN:" & Adapters(index, j, 0) & " settings..."
							end if
							For k = j+2 to maxSettings-1
								If StrComp(Adapters(index, k, 0), "", vbTextCompare) = 0 then
									Exit For		
								ElseIf Adapters(index, k, 0) = "VLAN" Then
									Exit For
								Else
									strQuery = "ASSOCIATORS OF {" & AdapterObj.Path_.Path & "}WHERE ResultClass = IANet_802dot1QVLANService"
									Set IANet_802dot1VLANService = wbemServices.ExecQuery(strQuery,,,SValueSet)
									If IANet_802dot1VLANService.Count <> 0 Then 
										For Each IANet_802dot1VLANObj In IANet_802dot1VLANService
											strQuery = "ASSOCIATORS OF {" & IANet_802dot1VLANObj.Path_.Path & "}WHERE ResultClass = IANet_VLAN"
											Set IANet_VLANSet = wbemServices.ExecQuery(strQuery,,,SValueSet)
											For Each IANet_VLANObj In IANet_VLANSet
												If StrComp(IANet_VLANObj.VLANName, Adapters(index, j, 0), vbTextCompare) = 0 Then
												
												strQuery = "ASSOCIATORS OF {" & IANet_VLANObj.Path_.Path & "} WHERE ResultClass = IANet_VLANSetting" 
														Set IANet_VLANconfigur = wbemServices.ExecQuery(strQuery,,,SValueSet)
													For Each IANet_VLANConfObj In IANet_VLANconfigur
														If StrComp(IANet_VLANConfObj.Caption, Adapters(index, k, 0), vbTextCompare) = 0 Then
															If StrComp(IANet_VLANConfObj.CurrentValue, Adapters(index, k, 1), vbTextCompare) <> 0 Then
																IANet_VLANConfObj.CurrentValue = Adapters(index, k, 1)
																Set Dumbpath = IANet_VLANConfObj.Put_ (wbemFlagUseAmendedQualifiers, SValueSet) 
																bModified = True
																Exit For				
															End If
														End If
													Next
												End If
											Next
										Next
									End If
								End If
							Next
							
							if savedJValue >= 0 AND x = numVLANS - 1 AND alreadyRestored <> true then
								j = savedJValue
								x = x - 1
								alreadyRestored = true
							else
								j = k + 1
							end if
							
						Next
						bVLAN = False
					ElseIf StrComp(Adapters(index, j, 0), "VLAN", vbTextCompare) = 0 Then
						bVLAN = True
						numVLANS = Adapters(index, 0, 2)
					ElseIf StrComp(Adapters(index, j, 0), "", vbTextCompare) <> 0 Then
					    For Each IANet_Obj In IANet_configur
						   If StrComp(Adapters(index, j, 0), IANet_Obj.Caption, vbTextCompare) = 0 Then								
								If StrComp(Adapters(index, j, 1), IANet_Obj.CurrentValue, vbTextCompare) <> 0 Then
									Set IANetSettingObj = wbemServices.Get(IANet_Obj.Path_.Path, ,SValueSet)
									If StrComp(IANet_Obj.Path_.Class, "IANet_AdapterSettingEnum", vbTextCompare) = 0 Then						
										bFoundPossibleValue = False
											
										For I = 0 To UBound(IANet_Obj.PossibleValues)
											If StrComp(IANet_Obj.PossibleValues(I), Adapters(index, j, 1), vbTextCompare) = 0 Then
												IANetSettingObj.CurrentValue = IANet_Obj.PossibleValues(I)
												Set Dumbpath = IANetSettingObj.Put_(wbemFlagUseAmendedQualifiers, SValueSet)
												bModified = True	
												bFoundPossibleValue = True
												Exit For
											End If
										Next
											
										If bFoundPossibleValue = False Then
											WScript.Echo "Can't apply the setting '" & Adapters(index, j, 0) & "' to the new value '" & _
											Adapters(index, j, 1) & "' because the new value is not a possible value."
										End If
									Else
										IANet_Obj.CurrentValue = Adapters(index, j, 1)	
										
										Set Dumbpath = IANet_Obj.Put_(wbemFlagUseAmendedQualifiers,SValueSet)'(wbemChangeFlagUpdateOnly, SValueSet)																
										bModified = True
										Exit For
									End If			
								End If								
							End If
						Next
						
						'Power Saver					
						Set InParameter = AdapterObj.Methods_.Item("SetPowerUsageOptions").InParameters
						If StrComp(Adapters(index, j, 0), "AutoPowerSaveModeEnabled", vbTextCompare) = 0 Then											
							InParameter.AutoPowerSaveModeEnabled = Adapters(index, j, 1)																				
						End if					
						If StrComp(Adapters(index, j, 0), "ReduceSpeedOnPowerDown", vbTextCompare) = 0 Then											
							InParameter.ReduceSpeedOnPowerDown = Adapters(index, j, 1)																				
						End if					
						'If StrComp(Adapters(index, j, 0), "SmartPowerDown", vbTextCompare) = 0 Then					
					'	If StrComp(Adapters(index, j, 0), "SPDEnabled", vbTextCompare) = 0 Then					
					'		InParameter.SmartPowerDown = Adapters(index, j, 1)														
					'	End if					
						If StrComp(Adapters(index, j, 0), "SavePowerNowEnabled", vbTextCompare) = 0 Then											
							InParameter.SavePowerNowEnabled = Adapters(index, j, 1)														
						End if		
						If StrComp(Adapters(index, j, 0), "EnhancedASPMPowerSaver", vbTextCompare) = 0 Then											
							InParameter.EnhancedASPMPowerSaver = Adapters(index, j, 1)														
						End if	
						Set OutParam = AdapterObj.ExecMethod_("SetPowerUsageOptions",InParameter,0,SValueSet)					
					End If
				Next	
		End If 	
	End If 
End Sub

'=================================================================================================
'
' ApplyTeamSettings(ByVal strSettingsIndex)
' Apply selected settings and return status to user
'
'=================================================================================================
Sub ApplyTeamSettings(ByVal strSettingsIndex)
	Dim TargetObjInstance 
	Dim bTeam, i, j, k, x, intCurCount, TeamAdapObj, TeamAdapObjSet, FinalVlanObject
	Dim IANet_configur, IANet_Obj, IANetSettingObj, TeamsObjSet, cstrPath,temObj
	Dim IANet_802dot1VLANService, IANet_802dot1VLANObj, TeamObjSet1, pos
	Dim IANet_VLANconfigur, IANet_VLANObj, Dumbpath, bTest, VLANObjectSet
	Dim VLANObjSet, VLANObj, b, a, TempVlanObject, InParameterObj, VlanObject
	Dim PartComponentString, GroupComponentString, TargetObj, TeamObj
	Dim TeamObj1, TeamsSet, TeamDeviceId, OutParameterObj, bFoundPossibleValue
	Dim strCapabilities, intTest, arrCaps, strQuery, bVLAN, numTVLANS
	Dim p, r,IANet_Virtualconfigur,temp,jj,adapterCount
	'For GVRP settings restore for Vlans
	Dim IANet_VlanIns,IANet_VlanObject,IANet_VLANSettingIns,IANet_VLANSettingObj
	Const wbemFlagUseAmendedQualifiers = &h20000
	bModified = False

	' for setting preferred primary
	Dim oTeamedMemberAdapters,oTeamedMemberAdaptersSet
	Dim AdapterInTeamOffset: AdapterInTeamOffset = 0
	On Error Resume Next
	
	p=0
	r=2		
	i=5

	CreateSessions() 'SCR 37163
	
	Redim Preserve AdapterPath(1)
	
	If Teams(index, 1, 2) = strSettingsIndex Then	
		bTeam = TRUE
		WScript.Echo "Creating Team: " & Teams(index, 0, 0) & "..."

		if (IsTeamSupportedInCurrentOS(Teams(index,1,0)) <> TRUE) then
			wscript.echo "Unable to create team. Team type not supported in this version of the OS."
			ExecApply wbemServices, strNetSerObjPath, SessionObject	' Without this before exiting, the script hangs/fails 
			exit sub
		end if

		'  Check to see that the team type is not GEC
		'  GEC are now to be created as an SLA team
		if ((Teams(index,1,0) = GEC_TEAM_TYPE)) then
			wscript.echo "Converting GEC to SLA"
			Teams(index,1,0) = SLA_TEAM_TYPE
		end if
		
		Set TeamsSet = wbemServices.Get("IANet_TeamOfAdapters",,SValueSet)
		Set InParameterObj = TeamsSet.Methods_.Item("CreateTeam").InParameters.SpawnInstance_()
		adapterCount = Teams(index, 1, 1)
		
		Redim Preserve AdapterPath(adapterCount)

		For jj=0 to adapterCount
			For Each AdapterObj In AdapterSets 
				If AdapterObj.Caption = Teams(index, r, 1) then 						
					AdapterPath(p) = AdapterObj.Path_.Path
					p=p+1
					r=r+1
				Elseif (bIsUpgrade = True) AND (AdapterObj.PermanentAddress = Teams(index, r, 5)) AND (AdapterObj.PermanentAddress <> "") then
					AdapterPath(p) = AdapterObj.Path_.Path
					p=p+1
					r=r+1
				Elseif (bIsUpgrade = False) AND (AdapterObj.PCIDeviceID = Teams(index, r, 5)) AND (AdapterObj.PCIDeviceID <> "") then
					AdapterPath(p) = AdapterObj.Path_.Path
					p=p+1
					r=r+1
				End if
			Next
		Next

		Redim Preserve AdapterPath(p-1)
		InParameterObj.Properties_.Item("Adapters") = AdapterPath		
		InParameterObj.TeamingMode = Teams(index, 1, 0)			
		InParameterObj.TeamName    = Teams(index, 0, 0)		
		InParameterObj.MFOEnable   = Teams(index, 1, 3)	

		Dim TempTeam
		TempTeam = InParameterObj.TeamName 
		Set OutParameterObj = TeamsSet.ExecMethod_("CreateTeam", InParameterObj, 0, SValueSet)		
		
		If Err <> 0 Then
			WScript.Echo "Adding Adapter Failed..."
			ErrorCheck()
			'If blTenGigFETeamError Then
			'	SetTenGigFERegKey()
			'End If	
		
		Else
			WScript.Echo "Create Team Success!!!"
			bNewTeam = True
		End If
		ExecApply wbemServices, strNetSerObjPath, SessionObject	'SCR 37163
		
		CreateSessions() 'SCR 37163
		
		Set oTeamedMemberAdaptersSet = wbemServices.InstancesOf("IANet_TeamedMemberAdapter",,SValueSet)
		If (IsNull(oTeamedMemberAdaptersSet) = FALSE) Then
			' first we have to find which adapter is the primary and set that one first!!
			For AdapterInTeamOffset = 0 to adapterCount-1 Step 1
				If( TeamedMemberAdapterPreferredPrimarySetting(index, AdapterInTeamOffset) = 1) Then	
					For each oTeamedMemberAdapters in oTeamedMemberAdaptersSet
						If(InStr(oTeamedMemberAdapters.PartComponent,TeamedMemberAdapterPartComponentSetting(index, AdapterInTeamOffset))) Then					
							oTeamedMemberAdapters.AdapterFunction = CStr(TeamedMemberAdapterPreferredPrimarySetting(index, AdapterInTeamOffset))
							oTeamedMemberAdapters.Put_  wbemFlagAmendedUpdateOnly, SValueSet				
							Exit For
						End If
					Next
					Exit For
				End If
			Next
			
			For each oTeamedMemberAdapters in oTeamedMemberAdaptersSet
				For AdapterInTeamOffset = 0 to adapterCount-1 Step 1
					If(InStr(oTeamedMemberAdapters.PartComponent,TeamedMemberAdapterPartComponentSetting(index, AdapterInTeamOffset))) Then
						If (TeamedMemberAdapterPreferredPrimarySetting(index, AdapterInTeamOffset) > 0) Then
							oTeamedMemberAdapters.AdapterFunction = CStr(TeamedMemberAdapterPreferredPrimarySetting(index, AdapterInTeamOffset))
							oTeamedMemberAdapters.Put_  wbemFlagAmendedUpdateOnly, SValueSet									
							Exit For
						End If
					End If
				Next
			Next
		End If

		WScript.Echo "Applying Team Settings to " & TempTeam	

		Set virtualAdapterSets = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter",,SValueSet) 
		For each virtualAdapterObj in virtualAdapterSets
			if StrComp(TempTeam,Mid(virtualAdapterObj.Caption,8), vbTextCompare) = 0 then				
				strQuery = "ASSOCIATORS OF {" & virtualAdapterObj.Path_.Path & "} WHERE ResultClass = IANet_TeamSetting"
				Set IANet_Virtualconfigur = wbemServices.ExecQuery(strQuery,,,SValueSet)
				TeamDeviceId = virtualAdapterObj.DeviceID			
				If Err <> 0 Then
					WScript.Echo "Query Failed..."
					ErrorCheck()	
				End if			
				
				bVLAN = False
				numTVLANS = Teams(index, 0, 2)	

				For j = 4 to maxSettings-1
					If StrComp(Teams(index, j, 0), "", vbTextCompare) = 0 then			
						Exit For	
					ElseIf bVLAN Then			
						Set TempVlanObject = wbemServices.Get("IANet_802dot1QVLANService",,SValueSet)
						Set InParameterObj = TempVlanObject.Methods_.Item("CreateVLAN").InParameters.SpawnInstance_()
						InParameterObj.Name = Teams(index, j, 0)
						InParameterObj.VLANNumber = Teams(index, j+1, 0)								

						if numTVLANS = 1 AND Teams(index, j+1, 0) = 0 then
							wscript.echo "Unable to create an Untagged VLAN without a Tagged VLAN on this Team"								
							exit for
						end if
						
						j = j + 1
						Set VlanObjectSet = wbemServices.InstancesOf("IANet_802dot1QVLANService", , SValueSet)
						For Each VlanObject In VlanObjectSet								
							If  TeamDeviceId = VlanObject.Name Then															
								Set FinalVlanObject = wbemServices.Get(VlanObject.Path_.Path, ,SValueSet)
								Set OutParameterObj = FinalVlanObject.ExecMethod_("CreateVLAN", InParameterObj, 0, SValueSet)																		
								Exit For
							Else 
								Exit For										
							End If
						Next

						bVLAN = false
						WSCript.Echo "updating VLAN:" & Teams(index, j-1, 0) & " settings..."																		

						For k = j+1 to maxSettings-1
							If StrComp(Teams(index, k, 0), "", vbTextCompare) = 0 then
								Exit For		
							ElseIf Teams(index, k, 0) = "VLAN" Then
								Exit For
							ElseIf StrComp(Teams(index, j, 0), "", vbTextCompare) <> 0 Then		
								Set IANet_VlanIns = wbemServices.InstancesOf("IANet_Vlan",,SValueSet) 
								For Each IANet_VlanObject in IANet_VlanIns													
									If IANet_VlanObject.ParentID = TeamDeviceId then																	
										strQuery = "ASSOCIATORS OF {" & IANet_VlanObject.Path_.Path & "}WHERE ResultClass = IANet_VLANSetting"
										Set IANet_VLANSettingIns = wbemServices.ExecQuery(strQuery,,,SValueSet)								
										For each IANet_VLANSettingObj in IANet_VLANSettingIns																					
											If StrComp(IANet_VLANSettingObj.Caption,Teams(index, k, 0), vbTextCompare) = 0 Then
												If StrComp(IANet_VLANSettingObj.CurrentValue, Teams(index, k, 1), vbTextCompare) <> 0 Then																																													
													IANet_VLANSettingObj.CurrentValue = Teams(index, k, 1)
													Set Dumbpath = IANet_VLANSettingObj.Put_ (wbemFlagUseAmendedQualifiers, SValueSet) 																
													Exit For
												End If										
											End if										
										Next																	
									End if								
								Next					
							End If														
						Next 					
						
					ElseIf StrComp(Teams(index, j, 0), "VLAN", vbTextCompare) = 0 Then
						bVLAN = True					
					ElseIf StrComp(Teams(index, j, 0), "", vbTextCompare) <> 0 Then		
					' Updating Team's Settings
						For Each IANet_Obj In IANet_Virtualconfigur
						  If StrComp(TeamDeviceId, IANet_Obj.ParentId, vbTextCompare) =0 Then
							If StrComp(Teams(index, j, 0), IANet_Obj.Caption, vbTextCompare) = 0 Then
								If StrComp(Teams(index, j, 1), IANet_Obj.CurrentValue, vbTextCompare) <> 0 Then
									If StrComp(IANet_Obj.Path_.Class, "IANet_TeamSettingEnum", vbTextCompare) = 0 Then
										bFoundPossibleValue = False
										For I = 0 To UBound(IANet_Obj.PossibleValues)
											If StrComp(IANet_Obj.PossibleValues(I), Teams(index, j, 1), vbTextCompare) = 0 Then
												IANet_Obj.CurrentValue = IANet_Obj.PossibleValues(I)
												Set Dumbpath = IANet_Obj.Put_(wbemFlagUseAmendedQualifiers, SValueSet)
												bModified = True
												bFoundPossibleValue = True
												Exit For
											End If
										Next
										If bFoundPossibleValue = False Then
											WScript.Echo "Can't apply the new '" & Teams(index, j, 0) & "' setting value of " & Teams(index, j, 1) & "' because the new value is not in the possible value range."
										End If
									Else
										IANet_Obj.CurrentValue = Teams(index, j, 1)
										Set Dumbpath = IANet_Obj.Put_ (wbemFlagUseAmendedQualifiers, SValueSet)									
										bModified = True
										Exit For
									End If			
								End If				
							End If
						  End if
						Next
					
					End If
				Next
			End if
		Next		
	End if
	ExecApply wbemServices, strNetSerObjPath, SessionObject	'SCR 37163
End Sub
'======================================================================================================

'Sub SetTenGigFERegKey()
	'Write a value to the Registry that Team Creation Failed because we found a 10/100 and 10 gig Team	
'	Dim oReg, strKeyPath,strValueName,strValue
'	Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")
'	strKeyPath ="SOFTWARE\INTEL\NIC\Team_FE_10Gig"
'	strValueName = "10Gig_FE_Team"
'	strValue = 1
'	WScript.Echo "Setting the Registry Value"
'	oReg.SetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,strValue	
	

'End Sub
'======================================================================================================
'
' Sub ErrorCheck()
' Displays Error and Extended Error Info to standard output
'
'======================================================================================================
Sub ErrorCheck()
	Dim errExObject, strErrText
	WScript.Echo "Error Number=" & Err.Number
	WScript.Echo "Error Description=" & Err.Description
	Set errExObject = CreateObject("WbemScripting.SWbemLastError")
	If IsNull(errExObject) = FALSE Then
		strErrText = errExObject.GetObjectText_
		WScript.Echo "MOF=" & strErrText
		'If(InStr(1,strErrText, "StatusCode = 10000;", 1) <> 0) then
		'	blTenGigFETeamError = true							
		'End If
	End If
End Sub
'======================================================================================================

'*****************************************************************************************
'Sub RemoveExpressTeams()
'Remove any existing team or vlan instances
'*****************************************************************************************
Sub RemoveExpressTeams()
	For each TempETObject in AdapterSets
		If TempETObject.ExpressTeaming =1 then			
			wscript.echo "Deleting existing Express Team..." 
			Set InParameterETObj = TempETObject.Methods_.Item("ExpressTeam").InParameters.SpawnInstance_()
			InParameterETObj.CreateExpressTeam = FALSE
			Set OutParameterETObj = TempETObject.ExecMethod_("ExpressTeam", InParameterETObj, 0, SValueSet)	
		End if
	Next
End Sub


'*****************************************************************************************
'Sub CreateExpressTeam()
'Creates Express Team
'*****************************************************************************************

Sub CreateExpressTeam()
	if (OSVersion <> "6.0")  then
		For each TempETObject in AdapterSets
			For index = 0 to (totalAdapters - 1)
				strOrgDispName = Adapters(index, 2, 1)		'Original Display Name
				if TempETObject.OriginalDisplayName = strOrgDispName then
				'If (StrComp(strOrgDispName,"" , vbTextCompare)) <> 0 Then
					wscript.echo "Creating Express Team on " & strOrgDispName				
					Set InParameterETObj = TempETObject.Methods_.Item("ExpressTeam").InParameters.SpawnInstance_()
					InParameterETObj.CreateExpressTeam = TRUE
					Set OutParameterETObj = TempETObject.ExecMethod_("ExpressTeam", InParameterETObj, 0, SValueSet)
					bExpressTeam = TRUE
					Exit For
				End if
			Next
		Next
	else
		wscript.echo "Express Teams not supported in Windows version 6.0"
	End if
End Sub
'*****************************************************************************************
'Sub ManageabilityTeam(objFile,objNetDeviceLogObj,wbemServices,objTeam)
'Checks if ManageabilityTeam is existing
'*****************************************************************************************

Sub ManageabilityTeam(objFile,objNetDeviceLogObj,wbemServices,objTeam)
	dim colAdapters
	On Error Resume Next
	Set colAdapters = wbemServices.InstancesOf("IANet_TeamOfAdapters where MFOEnabled=False")	'Need to implement true case
	If IsNull(objTeam.MFOEnabled) Then
		objFile.WriteLine "MFOEnabled=0"		
	Else
		' the value of MFOEnabled is stored in WMI as TRUE or FALSE which can be translated, so test as a boolean
		If ( objTeam.MFOEnabled = True ) Then
			objFile.WriteLine "MFOEnabled=1"
		Else
			objFile.WriteLine "MFOEnabled=0"
		End If
	End If
End Sub
'*****************************************************************************************
'Sub SaveExpressTeamInfo(objFile,objNetDevicePhyObj,wbemServices)
'Saves Express Team Info
'*****************************************************************************************
Sub SaveExpressTeamInfo(objFile,objNetDevicePhyObj,wbemServices)
	dim colAdapters1,objAdapters1
	On Error Resume Next
'	Set colAdapters = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter where ExpressTeaming=1")	
	
	objFile.WriteLine "Original Display Name=" & objNetDevicePhyObj.OriginalDisplayName
	objFile.WriteLine "ExpressTeam="& objNetDevicePhyObj.ExpressTeaming				

End Sub


'*****************************************************************************************
'*****************************************************************************************
'=======================================================================================
'
' Sub:  Remove()
'	Removes teams and VLANs from the system
'  
'=======================================================================================

Sub Remove()	
	CreateSessions()
	Set VLANObjSet = wbemServices.InstancesOf("IANet_VLAN",,SValueSet)
	
	' SCR 50668 Fix:  Without ANS installed, the IANet_VLAN class
	' Is not exposed in the WMI, causing the for each loop below to fail.  Since 
	' isNull() and isEmpty() are not reflecting when IANet_VLAN
	' is not there, it was needed to be done like this.  
	
	' Turn on error handling (script does not halt on errors)
	On Error Resume Next
		For Each VLANObj In VLANObjSet				
			' Check if there was an error accessing the VLANs collection
			' if not, save the ANS information
			if err.number = 0 then
				bHasTeamOrVLAN = TRUE 
				WScript.Echo "Removing any existing VLAN's..."
				VLANObj.Delete_ 0, SValueSet
			end if
		Next 
	' Turn off error handling (script halts on errors again)
	On Error Goto 0

	ExecApply wbemServices, strNetSerObjPath, SessionObject	

	CreateSessions()

	Set TeamsObjSet = wbemServices.InstancesOf("IANet_TeamOfAdapters",,SValueSet)

	' SCR 50668 Fix:  Without ANS installed, the IANet_TeamOfAdapters class
	' Is not exposed in the WMI, causing the for each loop below to fail.  Since 
	' isNull() and isEmpty() are not reflecting when IANet_TeamOfAdapters
	' is not there, it was needed to be done like this.  
	
	' Turn on error handling (script does not halt on errors)
	On Error Resume Next
		For Each TeamObj In TeamsObjSet		
			' Check if there was an error accessing the Team of Adapter collection
			' if not, save the ANS information
			if err.number = 0 then
				WScript.Echo "Removing any existing Teams..."
				bHasTeamOrVLAN = True		
				TeamObj.Delete_ 0, SValueSet
			end if
		Next
	On Error Goto 0

	'Remove Express Team
	if strRemoveAnsOnly <> "TRUE" then
		RemoveExpressTeams()
	end if
	
	ExecApply wbemServices, strNetSerObjPath, SessionObject	
End Sub

'****************************************************************************

'=====================================================================================
'
' Sub:	RestoreStaticIPSettings(ByVal strInputFname)'
'   
'=====================================================================================

Sub RestoreStaticIPSettings(ByVal strInputFname)
	Dim fso, wbemServices
	Dim VLANSets,VlanObj,TeamSets,TeamObj
	Dim AdapterSet, Adapter
	Dim ts, strLine
	Dim IPAddress(),IPSubnet(),DeviceGUID,TeamName,VlanName,AdapterName

		
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")		
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True	
		
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	
	If fso.FileExists (strInputFname) <> True Then
		Wscript.Echo "The file " & strInputFname
		Wscript.Echo "could not be found."
		Wscript.Echo "Either the file or the directory has been deleted "
		WScript.Echo "or Restore is being run on a cloned system."
		WScript.Echo "Unable to restore Static IP Addresses."	
		bError = TRUE
		Exit Sub
	Else	
		Set ts = fso.OpenTextFile(strInputFname, 1)
		
		ReDim Preserve IPAddress(0)
		ReDim Preserve IPSubnet(0)
			
		Do Until ts.AtEndOfStream		

			strLine = ts.ReadLine()
			If StrComp(strLine,"Team", vbTextCompare) = 0 Then			
				strLine = ts.ReadLine()
				'Store Team Name
				TeamName = Mid(strLine,11)								
				strLine = ts.ReadLine()				
				If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then
					strLine = ts.ReadLine()					
					'Store IP Address
					IPAddress(0) = strLine				
					'Store IP Subnet
					strLine = ts.ReadLine()							
					IPSubnet(0) = strLine					
					strLine = ts.ReadLine()	
				
					Set TeamSets = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter")
					For each TeamObj in TeamSets					
						if (StrComp(Mid(TeamObj.Caption,8),TeamName,VbTextCompare) = 0) then
							DeviceGUID = TeamObj.DeviceID							
							SetIPInfo DeviceGUID,IPAddress,IPSubnet				
						End If
					Next
					if(StrComp(strLine,"VLAN", vbTextCompare) = 0) Then					
						Do while StrComp(strLine, "", vbTextCompare) <> 0											
							strLine = ts.ReadLine()
							VlanName = Mid(strLine,11)										
							strLine = ts.ReadLine()	
							If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
								strLine = ts.ReadLine()
								'Store IP Address
								IPAddress(0) = strLine				
								strLine = ts.ReadLine()							
								'Store IP Subnet
								IPSubnet(0) = strLine					
								strLine = ts.ReadLine()	
								Set VLANSets = wbemServices.InstancesOf("IANet_VLAN")			
								For each VlanObj in VLANSets												
									If (StrComp(VlanObj.VLANName,VlanName,VbTextCompare) = 0) then
										If (InStr(1,VlanObj.Caption, TeamName, 1) <> 0) then
											DeviceGUID = VlanObj.Name												
											SetIPInfo DeviceGUID,IPAddress,IPSubnet				
											exit for
										End if
									End If
								Next
							Else
								'wscript.echo"Nothing to set Vlan-Team"			
								'exit do
							End if						
						Loop					
					End if
				ElseIf(StrComp(strLine,"VLAN", vbTextCompare) = 0) Then	
					Do while StrComp(strLine, "", vbTextCompare) <> 0					
						strLine = ts.ReadLine()
						VlanName = Mid(strLine,11)										
						strLine = ts.ReadLine()	
						If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
							strLine = ts.ReadLine()
							'Store IP Address
							IPAddress(0) = strLine				
							strLine = ts.ReadLine()							
							'Store IP Subnet
							IPSubnet(0) = strLine					
							strLine = ts.ReadLine()	
							Set VLANSets = wbemServices.InstancesOf("IANet_VLAN")			
							For each VlanObj in VLANSets												
								If (StrComp(VlanObj.VLANName,VlanName,VbTextCompare) = 0) then
									If (InStr(1,VlanObj.Caption, TeamName, 1) <> 0) then
										DeviceGUID = VlanObj.Name											
										SetIPInfo DeviceGUID,IPAddress,IPSubnet				
										exit for
									End if
								End If
							Next
						Else
							'wscript.echo"Nothing to set Vlan-Team"										
						End if						
					Loop
				Else 
					'wscript.echo"Nothing to set Team"			
				End if				
			ElseIf(StrComp(Mid(strLine,1,13),"Adapter Name=", vbTextCompare) = 0) Then	
				Do while StrComp(strLine, "", vbTextCompare) <> 0				
					AdapterName = Mid(strLine,14)								
					strLine = ts.ReadLine()
				
					If(StrComp(strLine,"VLAN", vbTextCompare) = 0) Then							
						strLine = ts.ReadLine()
						VlanName = Mid(strLine,11)										
						strLine = ts.ReadLine()	
						If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
							strLine = ts.ReadLine()
							'Store IP Address
							IPAddress(0) = strLine											
							strLine = ts.ReadLine()							
							'Store IP Subnet
							IPSubnet(0) = strLine			
							strLine = ts.ReadLine()	
							
							Set VLANSets = wbemServices.InstancesOf("IANet_VLAN")			
							For each VlanObj in VLANSets												
								If (StrComp(VlanObj.VLANName,VlanName,VbTextCompare) = 0) then
									If (InStr(1,VlanObj.Caption, AdapterName, 1) <> 0) then
										DeviceGUID = VlanObj.Name	
										SetIPInfo DeviceGUID,IPAddress,IPSubnet	
									End if			
								End If
							Next
						Else
							'Wscript.echo"Nothing to set vlan-adapter"										
						End if
					Else
						If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
							strLine = ts.ReadLine()
							'Store IP Address
							IPAddress(0) = strLine											
							strLine = ts.ReadLine()							
							'Store IP Subnet
							IPSubnet(0) = strLine			
							strLine = ts.ReadLine()	
							Set AdapterSet = wbemservices.instancesof("IANet_PhysicalEthernetAdapter")
							For each Adapter in AdapterSet
								if (StrComp(Adapter.OriginalDisplayName,AdapterName, vbTextCompare) = 0) then
									SetIPInfo Adapter.DeviceID, IPAddress, IPSubnet
								end if
							Next


						Else
							wscript.echo "Adapter Does not exist."
						End if 
					End if
																		
				Loop	
			End if																		
		Loop																			
	End if		
	wscript.echo "Finished Restoring Static IP Addresses"
End Sub
'=====================================================================================
'=====================================================================================
'Sub SetIPInfo(DeviceGUID,IPAddress,IPSubnet)
'=====================================================================================

Sub SetIPInfo(DeviceGUID,IPAddress,IPSubnet)
	On Error Resume Next 
	dim RebootReq, W32_NetAdapConfigObj	, W32_NetAdapConfig, objWMIService
	dim intReturn2
	RebootReq = 0


	dim jjj
	jjj = 0		
	For jjj=LBound(IPAddress) to UBound(IPAddress)
		wscript.Echo"IPAddress : " & IPAddress(jjj)
		wscript.Echo"IPSubnet : " & IPSubnet(jjj)
	Next 					


	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
	Set W32_NetAdapConfig = objWMIService.ExecQuery("SELECT * FROM Win32_NetworkAdapterConfiguration WHERE IPEnabled = True")

	If W32_NetAdapConfig.Count > 0 Then
 
		For Each W32_NetAdapConfigObj In W32_NetAdapConfig  			
  			If W32_NetAdapConfigObj.DHCPEnabled Then
  				If (strcomp(W32_NetAdapConfigObj.SettingID,DeviceGUID,vbTextCompare) = 0) then
    					WScript.Echo "Enabling static IP address for "	& W32_NetAdapConfigObj.Description
	    				intReturn = W32_NetAdapConfigObj.EnableStatic(IPAddress, IPSubnet)
    					If intReturn = 0 Then      					
      						WScript.Echo "DHCP disabled, static IP address enabled." 
    					ElseIf intReturn = 1 Then
      						RebootReq = RebootReq + 1
     						WScript.Echo "Reboot required."
	    				Else
      						WScript.Echo "Unable to enable static IP address."
    					End If
				End If
			Else	
				If (strcomp(W32_NetAdapConfigObj.SettingID,DeviceGUID,vbTextCompare) = 0) then
    					WScript.Echo "    Static IP address already enabled."
					intReturn2 = W32_NetAdapConfigObj.EnableStatic(IPAddress, IPSubnet)
					if intReturn2 <> 0 then
      						WScript.Echo "Unable to enable static IP address." 
					end if
  				End If
  			End If
		Next
		wscript.echo "IP Information Restored!!!"	
	Else 
		wscript.echo"No IP information available to restore"
	
	End If
	If (RebootReq > 0) Then
  		WScript.Echo VbCrLf & "Restart system for changes to take effect."
	End If	
End Sub
'=====================================================================================
'
' Sub:  SaveStaticIPSettings(ByVal strInputFname)
'		Save Adapter's, team's and VLAN's IP info to a text file.
'  
'=======================================================================================

Sub SaveStaticIPSettings(byVal strOutputFileName)
	dim colNetDevicesPhysical,colNetDevicesLogical
	dim objNetDevicePhyObj,objFile,objNetDeviceLogObj
	dim wbemServices,objWMIService

	
	'Create a configuration file
	If IsEmpty(CreateConfigFile(strOutputFileName)) then
		Exit Sub
	Else
		Set objFile=CreateConfigFile(strOutputFileName)
	End If
	objFile.WriteLine "*** NCS2 DMiX IP information  ***"
	objFile.WriteLine "*** Date " & Date & " Time " & Time() & "  ***"
	objFile.WriteLine "**********************************************"
	objFile.WriteLine ""	
	
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
		
	'Get all instances from IANet_PhysicalEthernetAdapter for adapters
	
	Set colNetDevicesPhysical = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter") 
	For each objNetDevicePhyObj in colNetDevicesPhysical
		If(InStr(1,objNetDevicePhyObj.Caption, "Intel(R)", 1) <> 0) AND (objNetDevicePhyObj.StatusInfo= 3) then				
				SaveVlanIPSettings objFile, objNetDevicePhyObj, wbemServices				
				SaveIPInfo objFile,objNetDevicePhyObj				
		End if
	Next
	
	objFile.WriteBlankLines(1)
	
	'Get all instances from IANet_LogicalEthernetAdapter for teams
	Set colNetDevicesLogical = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter") 
	
	' SCR 50668 Fix:  Without ANS installed, the IANet_LogicalEthernetAdapter class
	' Is not exposed in the WMI, causing the for each loop below to fail.  Since 
	' isNull() and isEmpty() are not reflecting when IANet_LogicalEthernetAdapter
	' is not there, it was needed to be done like this.  
	
	' Turn on error handling (script does not halt on errors)
	On Error Resume Next
		For each objNetDeviceLogObj in colNetDevicesLogical		
			' Check if there was an error accessing the Logical Adapter collection
			' if not, save the ANS information
			if err.number = 0 then
				SaveTeamIPSettings objFile, objNetDeviceLogObj, wbemServices					
				SaveVlanIPSettings objFile, objNetDeviceLogObj, wbemServices
				SaveIPInfo objFile,objNetDeviceLogObj		
				objFile.WriteBlankLines(1)	
			end if
		Next
	' Turn off error handling (script halts on errors again)
	On Error Goto 0

	objFile.WriteBlankLines(1)
	
	objFile.close
	Wscript.Echo "Static IP information saved!"
End Sub


'*****************************************************************************
Private Function CreateIPConfigFile(byVal strOutputFileName)
	dim fso
	dim file
	Dim szTmpFld
	Set fso = CreateObject("Scripting.FileSystemObject")
	szTmpFld = shell.ExpandEnvironmentStrings("%TEMP%")
	If (fso.FolderExists(szTmpFld)) <> True Then
		Wscript.Echo ""
		Wscript.Echo "Unable to create the configuration file required"
		Wscript.Echo "to save the static IP information."
		Wscript.Echo "Static IP information will not be saved."
		bError = TRUE
		Exit Function
	End If
	szTmpFld = szTmpFld & "\PROSetDX\DMIX\"
	'make sure the folder exists before creating the text file
	If (fso.FolderExists(szTmpFld)) <> True Then
		'need to create destination folder one directory at a time
		szTmpFld = shell.ExpandEnvironmentStrings("%TEMP%")
		szTmpFld = szTmpFld & "\PROSetDX"
		If (fso.FolderExists(szTmpFld)) <> True Then
			fso.CreateFolder(szTmpFld)
		End If
		szTmpFld = szTmpFld & "\DMIX"
		fso.CreateFolder(szTmpFld)
		If (fso.FolderExists(szTmpFld)) <> True Then
			Wscript.Echo ""
			Wscript.Echo "Unable to create the configuration file required"
			Wscript.Echo "to save the static IP information."
			Wscript.Echo "Static IP information will not be saved."
			bError = TRUE
			Exit Function
		End If
	End If
	Set file=fso.CreateTextFile(strOutputFileName,True)
	Set CreateIPConfigFile=file
End Function
'*****************************************************************************
Private Function SaveTeamIPSettings(objFile,objNetDeviceLogObj,wbemServices)
 	dim colTeam,objTeam,strQuery
	dim objWMIService, colWMISettings
 	 
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNCS2")
	Set colWMISettings = objWMIService.InstancesOf("IANET_TeamOfAdapters") 
	
	objFile.WriteLine "Team" 
	objFile.WriteLine "Team Name=" & Mid(objNetDeviceLogObj.Caption,8)
	
	For Each objTeam In colWMISettings 	    
		if (objTeam.StaticIPAddress <> "0.0.0.0") AND (objTeam.Caption = objNetDeviceLogObj.Caption) then
			
			objFile.WriteLine "IPADDRESS"
			objFile.WriteLine objTeam.StaticIPAddress
			objFile.WriteLine objTeam.SubnetMask
			objFile.WriteLine ""
		end if
	Next
End Function		


'*****************************************************************************
Private Function SaveVlanIPSettings(objFile,objAdapter,wbemServices)
	dim strQuery
	dim IANet_802dot1VLANService,IANet_VLANSet,IANet_802dot1VLANObj,IANet_VLANObj

		strQuery = "ASSOCIATORS OF {" & objAdapter.Path_.Path & "} WHERE ResultClass = IANet_802dot1QVLANService"
		Set IANet_802dot1VLANService = wbemServices.ExecQuery(strQuery)
		If IANet_802dot1VLANService.Count <> 0 Then 			
			For Each IANet_802dot1VLANObj In IANet_802dot1VLANService	      
				strQuery = "ASSOCIATORS OF {" & IANet_802dot1VLANObj.Path_.Path & "} WHERE ResultClass = IANet_VLAN"
				Set IANet_VLANSet = wbemServices.ExecQuery(strQuery)
				If IANet_VLANSet.Count > 0 Then								
					For Each IANet_VLANObj In IANet_VLANSet
						If(IANet_VLANObj.ParentType = 0) Then
							objFile.WriteLine "Adapter Name=" & objAdapter.Caption
							objFile.WriteLine "VLAN"						
							objFile.WriteLine "VLAN Name=" & IANet_VLANObj.VLANName
							SaveIPInfoForVLAN objFile,IANet_VLANObj						
							objFile.WriteBlankLines(1)	
						Else
							objFile.WriteLine "VLAN"						
							objFile.WriteLine "VLAN Name=" & IANet_VLANObj.VLANName
							SaveIPInfoForVLAN objFile,IANet_VLANObj						
						End if						
					Next
				End If
			Next
		End If
End Function

	

'****************************************************************************
Private Function SaveIPInfo(objFile,Adapter)
on error resume next
	dim objNetAdapter,colNetAdapters
	dim objWMIService
	dim GUID,colWMISettings
	dim i
	
	'Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/cimv2")
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNCS2")
		
	Set colWMISettings = objWMIService.InstancesOf("IANET_PhysicalEthernetAdapter where StaticIPAddress <> '0.0.0.0'") 
	
	For Each objNetAdapter In colWMISettings
		If strcomp(objNetAdapter.DeviceID,Adapter.DeviceID,vbTextCompare) = 0 then			
			objFile.WriteLine "Adapter Name=" & Adapter.OriginalDisplayName
			objFile.WriteLine "IPADDRESS"
			objFile.WriteLine objNetAdapter.StaticIPAddress
			objFile.WriteLine objNetAdapter.SubnetMask
			objFile.WriteLine ""
		End if
	Next		
End Function
'****************************************************************************
Private Function SaveIPInfoForVLAN(objFile,VLANObj)
	dim objNetAdapter,colNetAdapters
	dim objWMIService
	dim GUID,colWMISettings
	dim i
	
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")
	Set colWMISettings = objWMIService.InstancesOf("IANET_VLAN where StaticIPAddress <> '0.0.0.0'") 
	
	For Each objNetAdapter In colWMISettings
		if objNetAdapter.Caption = VLANObj.Caption then
			objFile.WriteLine "IPADDRESS"
			objFile.WriteLine objNetAdapter.StaticIPAddress
			objFile.WriteLine objNetAdapter.SubnetMask			
		end if
	Next		
End Function

'*****************************************************************************

Private Function Is_GVRP_GMRP_Setting(szReadLine)

	Dim bRet: bRet = FALSE
	If (InStr(szReadLine,"GVRP") > 0) Or _
	   (InStr(szReadLine,"GMRP") > 0) Then
	   	bRet = TRUE
	End If 	
	
	Is_GVRP_GMRP_Setting = bRet

End Function

Private Function IsTeamSupportedInCurrentOS(strTeamType)
	dim bRet: bRet = TRUE
	
'	*********************************************
'	WE ARE NO LONGER RESTRICTING TEAM TYPES IN XP
'	*********************************************
'	if ((OSVersion = "5.1") OR ((OSVersion = "5.2") AND (OSProductType = "1"))) AND (strTeamType <> "0") AND (strTeamType <> "1") then
'		bRet = FALSE
'	end if 
	
' 	ALWAYS RETURN TRUE, REVERSING DCR 170
	IsTeamSupportedInCurrentOS = bRet	
	
End function

'' SIG '' Begin signature block
'' SIG '' MIIbfgYJKoZIhvcNAQcCoIIbbzCCG2sCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFHPapHDC1tBt
'' SIG '' RkxWsocfj4JM/5rDoIIWnjCCA8QwggMtoAMCAQICEEe/
'' SIG '' GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIwMzIz
'' SIG '' NTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZl
'' SIG '' cmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2lnbiBU
'' SIG '' aW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzNIK8K
'' SIG '' fYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+jNtr
'' SIG '' 3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g99bbV
'' SIG '' XV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN3j/H
'' SIG '' tN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkSud5o
'' SIG '' L6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyfhOpU
'' SIG '' wQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvEs0dD
'' SIG '' mhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2ru66
'' SIG '' DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQGCCsG
'' SIG '' AQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29j
'' SIG '' c3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYBAf8C
'' SIG '' AQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2NybC52
'' SIG '' ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5nQ0Eu
'' SIG '' Y3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1UdDwEB
'' SIG '' /wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UEAxMM
'' SIG '' VFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GBAEpr
'' SIG '' +epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17IypMT
'' SIG '' 5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGLOIez
'' SIG '' 6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuFPrWd
'' SIG '' tdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIID/zCC
'' SIG '' AuegAwIBAgIQDekr8NTYKYgYMgUJXpp2iDANBgkqhkiG
'' SIG '' 9w0BAQUFADBTMQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
'' SIG '' VmVyaVNpZ24sIEluYy4xKzApBgNVBAMTIlZlcmlTaWdu
'' SIG '' IFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EwHhcNMDMx
'' SIG '' MjA0MDAwMDAwWhcNMDgxMjAzMjM1OTU5WjBXMQswCQYD
'' SIG '' VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
'' SIG '' LzAtBgNVBAMTJlZlcmlTaWduIFRpbWUgU3RhbXBpbmcg
'' SIG '' U2VydmljZXMgU2lnbmVyMIIBIjANBgkqhkiG9w0BAQEF
'' SIG '' AAOCAQ8AMIIBCgKCAQEAslAoSN3TaHqEGERmdV1+xLif
'' SIG '' Yyb/PUOcfBE4ECVVc9l1J2n9TrkgXNMK+aAbKu1VViFh
'' SIG '' 2B7b5Lwza8fv3aM3ZY4bkwy2Ux5cfGY1XwWKRf52Tt9T
'' SIG '' gKKBIJ2uiFyiCPflMPnuIjdMQgrO38YfxNZV6YE/tVKj
'' SIG '' LKoBevKiqo01/p/mXWoFnz1r47+WwP7MYPlA5wegROuB
'' SIG '' UW6lKvK2ihAo7Y/cBqCGUJp7SggNMB3KEJ5r9+lYrgSp
'' SIG '' QJmyKOiPFqw841NvS9M1nbVvZB2zliy7Ped56216+Rbm
'' SIG '' Jq2v75lTt0Aslbh5qv7UUqspdH5C7DkeomoW5lm7JGjY
'' SIG '' AIBDEIeAawIDAQABo4HKMIHHMDQGCCsGAQUFBwEBBCgw
'' SIG '' JjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNp
'' SIG '' Z24uY29tMAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAo
'' SIG '' oCagJIYiaHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNz
'' SIG '' LWNhLmNybDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAO
'' SIG '' BgNVHQ8BAf8EBAMCBsAwJAYDVR0RBB0wG6QZMBcxFTAT
'' SIG '' BgNVBAMTDFRTQTIwNDgtMS01NDANBgkqhkiG9w0BAQUF
'' SIG '' AAOCAQEAh3hw2k5SASBb4HnJgjDE/bkZlr2RAMO9zc3G
'' SIG '' 9A7Y//lNwDNiMBHF9XQb1JLeX5wgE7F8Rb5QzYPngBeD
'' SIG '' pyeTZxNG+8q4mEEDzJtRWwWLf6hv8xtQGyQu8mmNbCL3
'' SIG '' u8oWle0MdMBod9nrmWKHwXOQ+Il0eiOro5h7l7H3jylx
'' SIG '' TS51G0hB2vC1DSBU1negl4Jjaf0Jz4rwdbsJm9n5EVUm
'' SIG '' mmEyvnoCsHuGvqLDiyIseNE1drySc1z5ueZMFQojzOTS
'' SIG '' 1DQuSUAVPA9geiTGpWbvls9w6z7n9A1+3NF8o3ZxacGc
'' SIG '' T0cwNSGxoq8aYjwr2Y6qKgd72BizXHvinaVv/jyJrTCC
'' SIG '' BL8wggQooAMCAQICEEGRoVo5eN/PSWVmOB1MdcIwDQYJ
'' SIG '' KoZIhvcNAQEFBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNV
'' SIG '' BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
'' SIG '' cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24g
'' SIG '' QXV0aG9yaXR5MB4XDTA0MDcxNjAwMDAwMFoXDTE0MDcx
'' SIG '' NTIzNTk1OVowgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
'' SIG '' Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
'' SIG '' Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
'' SIG '' b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
'' SIG '' bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
'' SIG '' YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwggEiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC+vO68fu+D
'' SIG '' 6+A3T/sDEDi+CNKMfZ36kn8ZDMJr7kJSjN7THEgTJerB
'' SIG '' Y3r5UWXu06o79fCUnCv78mbUJNr39Z9uGTk2vNCjdgge
'' SIG '' IickbDiRJ+KESa4biqH9JYIsEDDocaso6HdKUfHszfjw
'' SIG '' VNRvwONtCo/Z2GSNY7ItTif2hQ7+beMpmeKFR3wthn/o
'' SIG '' V4+tZ8IzMpETIPypIxSabcKES3ZoBNVxLF0h+ogNJv0f
'' SIG '' LZEr5wFVTfJtNSiC39lrXLbW2aqB/V/Ng7pjndAi/Kk7
'' SIG '' Qmmyjjq1vLSeD17E6iyCiyj9UwiW3bUBINH5pRjnwO5R
'' SIG '' cDfhtgVIUkhvOOrD6Gx7RIS7AgMBAAGjggGgMIIBnDAS
'' SIG '' BgNVHRMBAf8ECDAGAQH/AgEAMEQGA1UdIAQ9MDswOQYL
'' SIG '' YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
'' SIG '' Ly93d3cudmVyaXNpZ24uY29tL3JwYTAxBgNVHR8EKjAo
'' SIG '' MCagJKAihiBodHRwOi8vY3JsLnZlcmlzaWduLmNvbS9w
'' SIG '' Y2EzLmNybDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYB
'' SIG '' BQUHAwMwDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIB
'' SIG '' AQQEAwIAATApBgNVHREEIjAgpB4wHDEaMBgGA1UEAxMR
'' SIG '' Q2xhc3MzQ0EyMDQ4LTEtNDMwHQYDVR0OBBYEFAj1Uej7
'' SIG '' /j09ZDZ8aM9beKjfucU3MIGABgNVHSMEeTB3oWOkYTBf
'' SIG '' MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
'' SIG '' IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
'' SIG '' aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHmCEHC6
'' SIG '' 5B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQEFBQADgYEA
'' SIG '' rjoXuEp7VfpkVexApO1JQZCZnIm8ry4dyngj+RwZD3/r
'' SIG '' aLwy2Yg43tw/04m0P7GClvGkWrrtLibT3nwBbgAKAKQG
'' SIG '' khFICUD5HBh5ZyMk4LvV4VCuG/UO3eAugc2Ao2xST5F1
'' SIG '' VYq6IvLS6kF1iC9jVX0eVFqVWcrZNIHAX172erUwggUD
'' SIG '' MIIC66ADAgECAgphDBIGAAAAAAAbMA0GCSqGSIb3DQEB
'' SIG '' BQUAMH8xCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
'' SIG '' aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
'' SIG '' ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xKTAnBgNVBAMT
'' SIG '' IE1pY3Jvc29mdCBDb2RlIFZlcmlmaWNhdGlvbiBSb290
'' SIG '' MB4XDTA2MDUyMzE3MDEyOVoXDTE2MDUyMzE3MTEyOVow
'' SIG '' XzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWdu
'' SIG '' LCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQ
'' SIG '' cmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGf
'' SIG '' MA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJXFme8huK
'' SIG '' ARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE
'' SIG '' BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnv
'' SIG '' T0Lwdd8KkMaOIG+YD/isI19wKTakyYbnsZogy1Olhec9
'' SIG '' vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABo4IBIzCC
'' SIG '' AR8wEQYDVR0gBAowCDAGBgRVHSAAMDYGCSsGAQQBgjcV
'' SIG '' BwQpMCcGHysGAQQBgjcVCI3g0YlOhNecwweGpob7HI/T
'' SIG '' v6YVARkCAW4CAQAwCwYDVR0PBAQDAgGGMA8GA1UdEwEB
'' SIG '' /wQFMAMBAf8wHQYDVR0OBBYEFOJ/e9h31d+eCj+etMsO
'' SIG '' Lqnv22l3MB0GCSsGAQQBgjcUAgQQHg4AQwByAG8AcwBz
'' SIG '' AEMAQTAfBgNVHSMEGDAWgBRi+wohW39DbhHaCVRQa/XS
'' SIG '' lnHxnjBVBgNVHR8ETjBMMEqgSKBGhkRodHRwOi8vY3Js
'' SIG '' Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
'' SIG '' aWNyb3NvZnRDb2RlVmVyaWZSb290LmNybDANBgkqhkiG
'' SIG '' 9w0BAQUFAAOCAgEAAeRGsztFf3UTh35fQ95GjsuKvbZH
'' SIG '' QbzMzHSR2M45UZWkprVHwO/S2nuPVxH0Mox8zT/uQtoE
'' SIG '' IUr3yEOISm9cyhT8S9GfTL3UVW7MAr4NpoiPhgm6pCW9
'' SIG '' 6LDw+otxTmewy4Ko145V9zfr8D6I7+Tgiv0cbi5hQUh1
'' SIG '' tLAsHSjYSQ/XFfAkcyU8zIgM3ihMZVT+Xq6M6hmtLFGy
'' SIG '' mzpH9TyANQEX4kmH1lRK+0urB7y/fXnPvzUAXLuez/yC
'' SIG '' iRs5oFGXtt7Aswf/RJZEwDQqGVyr7vA77ClOtRPFN4V+
'' SIG '' ddW01g0GbrXSbCNxZ+rxcY6vTnSqDPnsv0xY+l6Qm205
'' SIG '' y4aIP4scqBYy1f5tufH4s+rXkfY2R3jAJyoVx2jW9MX8
'' SIG '' T07IZz8QLUCf8R7JYUjnpwP8MXMM8EaI/lbaSSmV7wna
'' SIG '' o+W+72Ds2VSgWZwovVTvZhV/h0yE26YOlWcuUXs0ObZB
'' SIG '' woyEaCbcJAIJ54GOCpct7+6nuZimD4GNxxC14e2YL0hv
'' SIG '' U4VJZHib7F2slwtVJsPvuo3I0aUvWn+Ta2EaM5sYuKJi
'' SIG '' EN4k6nbhL0Pr7N18EjQkidooVa7ldU4xK2djtqjXq3MK
'' SIG '' A87F6lk/x+sqRa6oYlsvAJk5q7Rfc8MI7IARj0cOjyoT
'' SIG '' Q+GRBmJVu/+6PampPSYPrsp9YosVVYnWlDRN1mUwggUF
'' SIG '' MIID7aADAgECAhBlaAx4O3KKsqGIDfQjLe0yMA0GCSqG
'' SIG '' SIb3DQEBBQUAMIG0MQswCQYDVQQGEwJVUzEXMBUGA1UE
'' SIG '' ChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
'' SIG '' aWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1z
'' SIG '' IG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5j
'' SIG '' b20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJpU2lnbiBD
'' SIG '' bGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENBMB4XDTA2
'' SIG '' MDQxNzAwMDAwMFoXDTA5MDUzMTIzNTk1OVowgcgxCzAJ
'' SIG '' BgNVBAYTAlVTMQ8wDQYDVQQIEwZPcmVnb24xEjAQBgNV
'' SIG '' BAcTCUhpbGxzYm9ybzEaMBgGA1UEChQRSW50ZWwgQ29y
'' SIG '' cG9yYXRpb24xPjA8BgNVBAsTNURpZ2l0YWwgSUQgQ2xh
'' SIG '' c3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxpZGF0
'' SIG '' aW9uIHYyMRwwGgYDVQQLFBNMQU4gQWNjZXNzIERpdmlz
'' SIG '' aW9uMRowGAYDVQQDFBFJbnRlbCBDb3Jwb3JhdGlvbjCB
'' SIG '' nzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAwyLZ4oZO
'' SIG '' oz2TsUVpMbTkMSu7FTr6IAFxT76/vwP87pUP+Tc8HLXz
'' SIG '' eZ92wxf3ngYXNN8A6KrQ04yzjfET+YinhJriRPAhoVuS
'' SIG '' LdmHKVk1HeW6djY4oV7uUd+rY0VmmRVAhHQAhWVk+mYX
'' SIG '' sPhQbItp8oBwfQpbLJ0xLBZc6H+sDp8CAwEAAaOCAX8w
'' SIG '' ggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMEAG
'' SIG '' A1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIwMDQt
'' SIG '' Y3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3JsMEQG
'' SIG '' A1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggrBgEF
'' SIG '' BQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3Jw
'' SIG '' YTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEFBQcB
'' SIG '' AQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLnZl
'' SIG '' cmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDovL0NT
'' SIG '' QzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMtMjAw
'' SIG '' NC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09ZDZ8
'' SIG '' aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAWBgor
'' SIG '' BgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0BAQUF
'' SIG '' AAOCAQEAHJxeECDssLQqkdtS3STjZ3h4JINKZCZqhT4u
'' SIG '' YG2kYEiKwzHDVgDENxPUTfmmPjVMgC9v0YOTIGBny2OG
'' SIG '' 8C0xybHsDPItIGfcOt1xvLIwY0NoIracMeGqnCNuERFl
'' SIG '' G6Z631+nhLmKJkoz4D5hu35bPkcVLOXU1JGMqSv8WBBj
'' SIG '' scg3d0gPKffALwj0cHjpXg7KJocU/Z5czno4G8/NVZGK
'' SIG '' 9F0+Ox8qgoRt8pKkoqyZ6U+13wC3PPkJaLLUd4m/EPZn
'' SIG '' O05cO2Yx7twzaiqhtt4fw92h0msQydnEu5LO/ziw5JwJ
'' SIG '' OanVsXnw0c9yUUBrRzOBx5v0+pZw1sYyWn+ZCa4LYzGC
'' SIG '' BEwwggRIAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEXMBUG
'' SIG '' A1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
'' SIG '' cmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsTMlRl
'' SIG '' cm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2ln
'' SIG '' bi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJpU2ln
'' SIG '' biBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENBAhBl
'' SIG '' aAx4O3KKsqGIDfQjLe0yMAkGBSsOAwIaBQCggdYwGQYJ
'' SIG '' KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
'' SIG '' NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkE
'' SIG '' MRYEFIJsPU42bFyRQhN999SzMTklFpzrMHYGCisGAQQB
'' SIG '' gjcCAQwxaDBmoGSAYgBEADoAXABTAGEAbgBkAGIAbwB4
'' SIG '' AFwAOQA0ADUAMQA3AFwATQBTAEkAXwBJAG4AcwB0AGEA
'' SIG '' bABsAFwAUwBjAHIAaQBwAHQAcwBcAFMAYQB2AFIAZQBz
'' SIG '' AEQAWAAuAHYAYgBzMA0GCSqGSIb3DQEBAQUABIGAdxZw
'' SIG '' CUc7eNNzJe7u2viMWEBds8Nt6Lhzi+NJcM7taQpm78zq
'' SIG '' 7KSUnuxs4v2PxD75OtBxqpfBQONxJFowudp827sAjbco
'' SIG '' IwB9Ni1f51MdOECeT7DyDp7+wEFhU+IjMX3uMjbzXJ2e
'' SIG '' sas9jbaZ5mOrJWdjBPD21P/SHmQfFrIdbDyhggH/MIIB
'' SIG '' +wYJKoZIhvcNAQkGMYIB7DCCAegCAQEwZzBTMQswCQYD
'' SIG '' VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
'' SIG '' KzApBgNVBAMTIlZlcmlTaWduIFRpbWUgU3RhbXBpbmcg
'' SIG '' U2VydmljZXMgQ0ECEA3pK/DU2CmIGDIFCV6adogwDAYI
'' SIG '' KoZIhvcNAgUFAKBZMBgGCSqGSIb3DQEJAzELBgkqhkiG
'' SIG '' 9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTA3MDQyNzAzMTkz
'' SIG '' NFowHwYJKoZIhvcNAQkEMRIEEIDj5MRUYNMW4vMuSDD8
'' SIG '' znYwDQYJKoZIhvcNAQEBBQAEggEAUE1VrtTMyME/fwdu
'' SIG '' tLxm5w5kmt0llIS3K4jKGlb67IK/DUCwRbEaidcw/1rF
'' SIG '' pp4Dpg7suoRBcu6DbFzoaNXDpk/nI6b7zLuDPhaxpAfV
'' SIG '' hqqu49dTs3UIbLFa7fs9tvToYuATCf4jBq+wzUPUi31e
'' SIG '' Avu6T/UAk+5fS0zIeTqo7vy9fKx4p5vSvnF1xwx7AKqc
'' SIG '' kZZwtR7dDP2ew02ZmJIhqYroHjGrQQxardQwTLGzEzEV
'' SIG '' BgsjLlByOfyYfioLWSikmU5iTFwI7gFf63FVrB1rtJbJ
'' SIG '' y6mvhS1b+LTSBVHPARk5WTJwqyG3jWWjcXPjQxw03+44
'' SIG '' Lw7SGpDhHpGwo7QxEg==
'' SIG '' End signature block
