/*******************************************************************************


"This software program is licensed subject to the GNU General Public License 
(GPL). Version 2, June 1991, available at 
<http://www.fsf.org/copyleft/gpl.html>"

GNU General Public License 

Version 2, June 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.  
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

Everyone is permitted to copy and distribute verbatim copies of this license
document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to 
share and change it. By contrast, the GNU General Public License is intended
to guarantee your freedom to share and change free software--to make sure 
the software is free for all its users. This General Public License applies 
to most of the Free Software Foundation's software and to any other program 
whose authors commit to using it. (Some other Free Software Foundation 
software is covered by the GNU Library General Public License instead.) You 
can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not price. Our
General Public Licenses are designed to make sure that you have the freedom 
to distribute copies of free software (and charge for this service if you 
wish), that you receive source code or can get it if you want it, that you 
can change the software or use pieces of it in new free programs; and that 
you know you can do these things.

To protect your rights, we need to make restrictions that forbid anyone to 
deny you these rights or to ask you to surrender the rights. These 
restrictions translate to certain responsibilities for you if you distribute
copies of the software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or 
for a fee, you must give the recipients all the rights that you have. You 
must make sure that they, too, receive or can get the source code. And you 
must show them these terms so they know their rights.
 
We protect your rights with two steps: (1) copyright the software, and (2) 
offer you this license which gives you legal permission to copy, distribute 
and/or modify the software. 

Also, for each author's protection and ours, we want to make certain that 
everyone understands that there is no warranty for this free software. If 
the software is modified by someone else and passed on, we want its 
recipients to know that what they have is not the original, so that any 
problems introduced by others will not reflect on the original authors' 
reputations. 

Finally, any free program is threatened constantly by software patents. We 
wish to avoid the danger that redistributors of a free program will 
individually obtain patent licenses, in effect making the program 
proprietary. To prevent this, we have made it clear that any patent must be 
licensed for everyone's free use or not licensed at all. 

The precise terms and conditions for copying, distribution and modification 
follow. 

TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice
   placed by the copyright holder saying it may be distributed under the 
   terms of this General Public License. The "Program", below, refers to any
   such program or work, and a "work based on the Program" means either the 
   Program or any derivative work under copyright law: that is to say, a 
   work containing the Program or a portion of it, either verbatim or with 
   modifications and/or translated into another language. (Hereinafter, 
   translation is included without limitation in the term "modification".) 
   Each licensee is addressed as "you". 

   Activities other than copying, distribution and modification are not 
   covered by this License; they are outside its scope. The act of running 
   the Program is not restricted, and the output from the Program is covered 
   only if its contents constitute a work based on the Program (independent 
   of having been made by running the Program). Whether that is true depends
   on what the Program does. 

1. You may copy and distribute verbatim copies of the Program's source code 
   as you receive it, in any medium, provided that you conspicuously and 
   appropriately publish on each copy an appropriate copyright notice and 
   disclaimer of warranty; keep intact all the notices that refer to this 
   License and to the absence of any warranty; and give any other recipients 
   of the Program a copy of this License along with the Program. 

   You may charge a fee for the physical act of transferring a copy, and you 
   may at your option offer warranty protection in exchange for a fee. 

2. You may modify your copy or copies of the Program or any portion of it, 
   thus forming a work based on the Program, and copy and distribute such 
   modifications or work under the terms of Section 1 above, provided that 
   you also meet all of these conditions: 

   * a) You must cause the modified files to carry prominent notices stating 
        that you changed the files and the date of any change. 

   * b) You must cause any work that you distribute or publish, that in 
        whole or in part contains or is derived from the Program or any part 
        thereof, to be licensed as a whole at no charge to all third parties
        under the terms of this License. 

   * c) If the modified program normally reads commands interactively when 
        run, you must cause it, when started running for such interactive 
        use in the most ordinary way, to print or display an announcement 
        including an appropriate copyright notice and a notice that there is
        no warranty (or else, saying that you provide a warranty) and that 
        users may redistribute the program under these conditions, and 
        telling the user how to view a copy of this License. (Exception: if 
        the Program itself is interactive but does not normally print such 
        an announcement, your work based on the Program is not required to 
        print an announcement.) 

   These requirements apply to the modified work as a whole. If identifiable 
   sections of that work are not derived from the Program, and can be 
   reasonably considered independent and separate works in themselves, then 
   this License, and its terms, do not apply to those sections when you 
   distribute them as separate works. But when you distribute the same 
   sections as part of a whole which is a work based on the Program, the 
   distribution of the whole must be on the terms of this License, whose 
   permissions for other licensees extend to the entire whole, and thus to 
   each and every part regardless of who wrote it. 

   Thus, it is not the intent of this section to claim rights or contest 
   your rights to work written entirely by you; rather, the intent is to 
   exercise the right to control the distribution of derivative or 
   collective works based on the Program. 

   In addition, mere aggregation of another work not based on the Program 
   with the Program (or with a work based on the Program) on a volume of a 
   storage or distribution medium does not bring the other work under the 
   scope of this License. 

3. You may copy and distribute the Program (or a work based on it, under 
   Section 2) in object code or executable form under the terms of Sections 
   1 and 2 above provided that you also do one of the following: 

   * a) Accompany it with the complete corresponding machine-readable source 
        code, which must be distributed under the terms of Sections 1 and 2 
        above on a medium customarily used for software interchange; or, 

   * b) Accompany it with a written offer, valid for at least three years, 
        to give any third party, for a charge no more than your cost of 
        physically performing source distribution, a complete machine-
        readable copy of the corresponding source code, to be distributed 
        under the terms of Sections 1 and 2 above on a medium customarily 
        used for software interchange; or, 

   * c) Accompany it with the information you received as to the offer to 
        distribute corresponding source code. (This alternative is allowed 
        only for noncommercial distribution and only if you received the 
        program in object code or executable form with such an offer, in 
        accord with Subsection b above.) 

   The source code for a work means the preferred form of the work for 
   making modifications to it. For an executable work, complete source code 
   means all the source code for all modules it contains, plus any 
   associated interface definition files, plus the scripts used to control 
   compilation and installation of the executable. However, as a special 
   exception, the source code distributed need not include anything that is 
   normally distributed (in either source or binary form) with the major 
   components (compiler, kernel, and so on) of the operating system on which
   the executable runs, unless that component itself accompanies the 
   executable. 

   If distribution of executable or object code is made by offering access 
   to copy from a designated place, then offering equivalent access to copy 
   the source code from the same place counts as distribution of the source 
   code, even though third parties are not compelled to copy the source 
   along with the object code. 

4. You may not copy, modify, sublicense, or distribute the Program except as
   expressly provided under this License. Any attempt otherwise to copy, 
   modify, sublicense or distribute the Program is void, and will 
   automatically terminate your rights under this License. However, parties 
   who have received copies, or rights, from you under this License will not
   have their licenses terminated so long as such parties remain in full 
   compliance. 

5. You are not required to accept this License, since you have not signed 
   it. However, nothing else grants you permission to modify or distribute 
   the Program or its derivative works. These actions are prohibited by law 
   if you do not accept this License. Therefore, by modifying or 
   distributing the Program (or any work based on the Program), you 
   indicate your acceptance of this License to do so, and all its terms and
   conditions for copying, distributing or modifying the Program or works 
   based on it. 

6. Each time you redistribute the Program (or any work based on the 
   Program), the recipient automatically receives a license from the 
   original licensor to copy, distribute or modify the Program subject to 
   these terms and conditions. You may not impose any further restrictions 
   on the recipients' exercise of the rights granted herein. You are not 
   responsible for enforcing compliance by third parties to this License. 

7. If, as a consequence of a court judgment or allegation of patent 
   infringement or for any other reason (not limited to patent issues), 
   conditions are imposed on you (whether by court order, agreement or 
   otherwise) that contradict the conditions of this License, they do not 
   excuse you from the conditions of this License. If you cannot distribute 
   so as to satisfy simultaneously your obligations under this License and 
   any other pertinent obligations, then as a consequence you may not 
   distribute the Program at all. For example, if a patent license would 
   not permit royalty-free redistribution of the Program by all those who 
   receive copies directly or indirectly through you, then the only way you 
   could satisfy both it and this License would be to refrain entirely from 
   distribution of the Program. 

   If any portion of this section is held invalid or unenforceable under any
   particular circumstance, the balance of the section is intended to apply
   and the section as a whole is intended to apply in other circumstances. 

   It is not the purpose of this section to induce you to infringe any 
   patents or other property right claims or to contest validity of any 
   such claims; this section has the sole purpose of protecting the 
   integrity of the free software distribution system, which is implemented 
   by public license practices. Many people have made generous contributions
   to the wide range of software distributed through that system in 
   reliance on consistent application of that system; it is up to the 
   author/donor to decide if he or she is willing to distribute software 
   through any other system and a licensee cannot impose that choice. 

   This section is intended to make thoroughly clear what is believed to be 
   a consequence of the rest of this License. 

8. If the distribution and/or use of the Program is restricted in certain 
   countries either by patents or by copyrighted interfaces, the original 
   copyright holder who places the Program under this License may add an 
   explicit geographical distribution limitation excluding those countries, 
   so that distribution is permitted only in or among countries not thus 
   excluded. In such case, this License incorporates the limitation as if 
   written in the body of this License. 

9. The Free Software Foundation may publish revised and/or new versions of 
   the General Public License from time to time. Such new versions will be 
   similar in spirit to the present version, but may differ in detail to 
   address new problems or concerns. 

   Each version is given a distinguishing version number. If the Program 
   specifies a version number of this License which applies to it and "any 
   later version", you have the option of following the terms and 
   conditions either of that version or of any later version published by 
   the Free Software Foundation. If the Program does not specify a version 
   number of this License, you may choose any version ever published by the 
   Free Software Foundation. 

10. If you wish to incorporate parts of the Program into other free programs
    whose distribution conditions are different, write to the author to ask 
    for permission. For software which is copyrighted by the Free Software 
    Foundation, write to the Free Software Foundation; we sometimes make 
    exceptions for this. Our decision will be guided by the two goals of 
    preserving the free status of all derivatives of our free software and 
    of promoting the sharing and reuse of software generally. 

   NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
    FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN 
    OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES 
    PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
    EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
    ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH 
    YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL 
    NECESSARY SERVICING, REPAIR OR CORRECTION. 

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
    WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
    REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
    DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
    DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
    (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
    INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
    THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR 
    OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

END OF TERMS AND CONDITIONS

How to Apply These Terms to Your New Programs

If you develop a new program, and you want it to be of the greatest 
possible use to the public, the best way to achieve this is to make it free 
software which everyone can redistribute and change under these terms. 

To do so, attach the following notices to the program. It is safest to 
attach them to the start of each source file to most effectively convey the
exclusion of warranty; and each file should have at least the "copyright" 
line and a pointer to where the full notice is found. 

one line to give the program's name and an idea of what it does.
Copyright (C) yyyy  name of author

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the Free 
Software Foundation; either version 2 of the License, or (at your option) 
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT 
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 
Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Also add information on how to contact you by electronic and paper mail. 

If the program is interactive, make it output a short notice like this when 
it starts in an interactive mode: 

Gnomovision version 69, Copyright (C) year name of author Gnomovision comes 
with ABSOLUTELY NO WARRANTY; for details type 'show w'.  This is free 
software, and you are welcome to redistribute it under certain conditions; 
type 'show c' for details.

The hypothetical commands 'show w' and 'show c' should show the appropriate 
parts of the General Public License. Of course, the commands you use may be 
called something other than 'show w' and 'show c'; they could even be 
mouse-clicks or menu items--whatever suits your program. 

You should also get your employer (if you work as a programmer) or your 
school, if any, to sign a "copyright disclaimer" for the program, if 
necessary. Here is a sample; alter the names: 

Yoyodyne, Inc., hereby disclaims all copyright interest in the program 
'Gnomovision' (which makes passes at compilers) written by James Hacker.

signature of Ty Coon, 1 April 1989
Ty Coon, President of Vice

This General Public License does not permit incorporating your program into 
proprietary programs. If your program is a subroutine library, you may 
consider it more useful to permit linking proprietary applications with the 
library. If this is what you want to do, use the GNU Library General Public 
License instead of this License.

*******************************************************************************/


#include <linux/version.h>
#include <linux/pci.h>
#include <asm/io.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include <linux/fs.h>
#include <linux/wrapper.h>
#include <linux/pm.h>
#include "mng_drv_core.h"
#include "mng_proc.h" 
#include "mng_host_ioctl.h"      
#include "mng_host_cmds.h"      


//assume page is 2^n ...
#define MNG_PAGE_ALIGN(addr)    ( (addr) & (~(PAGE_SIZE - 1)))
#define MNG_PAGE_OFFSET(addr)   ( (addr) & (PAGE_SIZE - 1))
#define E100_REBOOT_NOTIFY_PRIORITY 	0
#define E1000_REBOOT_NOTIFY_PRIORITY 	0

//local function prototypes:
////////////////////////////////////////////////////////////////

//file operations functions:
loff_t mng_host_llseek(struct file *filp, loff_t off, int whence);
int	mng_host_open(struct inode *inode, struct file *filp);
int mng_host_release(struct inode *inode, struct file *filp);
int mng_host_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg);

//reboot notifier
static int mng_reboot_nt_register(struct mng_dev *dev);
static int mng_reboot_nt_unregister(struct mng_dev *dev);
static int mng_reboot_notify(struct notifier_block *nt, unsigned long type,
                             void *unused);

//power management events:
#ifdef CONFIG_PM
static int mng_pm_register(struct mng_dev *dev);
static void mng_pm_unregister(struct mng_dev *dev);
static int mng_pm_event(struct pm_dev *pm_dev_data, pm_request_t rqst, void *data);
#endif

//auxillary funcs
int __init mng_is_supported(struct pci_dev *pcid);
unsigned long __init mng_iomem(struct pci_dev *pcid);
static int check_reg_access_valid(struct mng_reg_access *reg_access);

//init/cleanup
int __init mng_init(void);
void __exit mng_cleanup(void);
static int __init mng_devices_init(void);
static int __exit mng_devices_cleanup(void);
static int __init mng_probe(struct pci_dev *pcid);
static int mng_dev_init(struct pci_dev *pcid, struct mng_dev *dev);
static int mng_dev_cleanup(struct mng_dev *dev);
////////////////////////////////////////////////////////////////


//file operations:
static struct file_operations mng_host_fops = {
	llseek:		mng_host_llseek,
	open:       mng_host_open,
	release:    mng_host_release,
	ioctl:      mng_host_ioctl,
};

//static(global) variables:
static int major;										//driver major number
static struct mng_dev mng_devices[MNG_MAX_DEVICES];		//holds all mng devices


//function implementation:
/////////////////////////

static int mng_reboot_nt_register(struct mng_dev *dev) {
	int priority;

	dev->reboot_nt.nt_block.notifier_call = mng_reboot_notify;
	dev->reboot_nt.nt_block.next = NULL;
	if (E100_REBOOT_NOTIFY_PRIORITY > E1000_REBOOT_NOTIFY_PRIORITY) {
		priority = E100_REBOOT_NOTIFY_PRIORITY;
	} else {
		priority = E1000_REBOOT_NOTIFY_PRIORITY;
	}
	dev->reboot_nt.nt_block.priority = priority+1;
	dev->reboot_nt.client = dev;

	return (register_reboot_notifier(&(dev->reboot_nt.nt_block)));
}
  
static int mng_reboot_nt_unregister(struct mng_dev *dev) {
	return (unregister_reboot_notifier(&(dev->reboot_nt.nt_block)));
}

static int mng_reboot_notify(struct notifier_block *nt, unsigned long type, void *unused) {

    struct mng_reboot_notifier *reboot_nt = (struct mng_reboot_notifier *)nt;
	struct mng_dev *dev = reboot_nt->client;

    printk(KERN_DEBUG "MNG: power down notifier %u for %s\n",
           (int)type, reboot_nt->client->pcid->name);

	//check if host i/f is enabled by checking the mode in the FWSM reg
	if (mng_host_if_enabled(dev)) {
		printk(KERN_DEBUG "MNG: HOST-IF not active\n");
		return NOTIFY_DONE;  //nothing to do
	}

	switch(type) {
	case SYS_DOWN:
	case SYS_HALT:
	case SYS_POWER_OFF:
		down(&(dev->wdog.wdog_sem));
		mng_stop_watchdog_process(dev);
		up(&(dev->wdog.wdog_sem));
		mng_host_cmd_set_system_state(dev, CASF_SYSTEM_STATE_UNKNOWN);	
		mng_host_cmd_set_arp_en(dev, 1);
	}

    return NOTIFY_DONE;
}

#ifdef CONFIG_PM
static int
mng_pm_register(struct mng_dev *dev)
{
   dev->pm_dev_data = pm_register(0, 0, mng_pm_event);
   if (dev->pm_dev_data) {
       dev->pm_dev_data->data = (void *)dev;
	   return 0;
   }

   return -ENOMEM;
}

static void
mng_pm_unregister(struct mng_dev *dev)
{
	if (dev->pm_dev_data) {
       pm_unregister(dev->pm_dev_data);
   }
}

static int
mng_pm_event(struct pm_dev *pm_dev_data, pm_request_t rqst, void *data)
{
	struct mng_dev *dev = pm_dev_data->data;

	printk(KERN_DEBUG "MNG: PM event %d for %s\n", (int)rqst,
	       dev->pcid->name);

	//check if host i/f is enabled by checking the mode in the FWSM reg
	if (mng_host_if_enabled(dev)) {
		printk(KERN_DEBUG "MNG: HOST-IF not active\n");
		return 0;  //nothing to do
	}
    
	down(&(dev->wdog.wdog_sem));
	switch (rqst){
	case PM_RESUME:
		if (dev->wdog.pre_suspend_status == MNG_WDOG_RUNNING) {
			mng_start_watchdog_process(dev);
		}
		mng_host_cmd_set_system_state(dev, CASF_SYSTEM_STATE_S0);
		mng_host_cmd_set_arp_en(dev, 0);
		break;
	case PM_SUSPEND:
		dev->wdog.pre_suspend_status = dev->wdog.status;
		if (dev->wdog.pre_suspend_status == MNG_WDOG_RUNNING) {
			mng_stop_watchdog_process(dev);
		}
		mng_host_cmd_set_system_state(dev, CASF_SYSTEM_STATE_UNKNOWN);
		mng_host_cmd_set_arp_en(dev, 1);
		break;
	}
	up(&(dev->wdog.wdog_sem));
	return 0;
}
#endif /*CONFIG_PM*/


inline int __init
mng_is_supported(struct pci_dev *pcid){
  u16 dev;  
  pci_read_config_word(pcid, PCI_DEVICE_ID, &dev);
  
  if (((dev>=0x105A) && (dev<=0x105C)) ||
	  ((dev>=0x105E) && (dev<=0x1060))  ||
      ((dev>=0x108B) && (dev<=0x108C)) ||
	  (dev == 0x107D) || (dev == 0x1096) ||
	  (dev == 0x10BA) || (dev == 0x10A7) ||
	  (dev == 0x1049) || (dev == 0x104A) ||
	  (dev == 0x104B) || (dev == 0x104C) ||
	  (dev == 0x10BD) || (dev == 0x10BE)
#ifdef USING_TK_FPGA
      || (dev == 0xF0F8)
	  || (dev == 0xF0F0)
#endif
#ifdef USING_FPGA
	  || (dev==0xbbbb)
#endif
	  ) {
	  return 0;
  }

  return -1;
}
  

inline unsigned long __init
mng_iomem(struct pci_dev *pcid)
{
  unsigned long raw_mem = pci_resource_start(pcid, 0);

#if BITS_PER_LONG == 64
  if(raw_mem & PCI_BASE_ADDRESS_MEM_TYPE_64){
    raw_mem |= (pci_resource_start(pcid, 1) << 32);
  }
#endif /* BITS_PER_LONG */

  return raw_mem & PCI_BASE_ADDRESS_MEM_MASK;
}


int __init mng_init(void)
{
  int res = -ENODEV;
  struct pci_dev *dev = NULL;

  SET_MODULE_OWNER(&mng_host_fops);

  if(pci_present() == 0){
    return -ENODEV;
  }

  if (mng_devices_init()) {
	  return -EIO;
  }

  while( (dev = pci_find_device(PCI_VENDOR_ID_INTEL,PCI_ANY_ID,dev))){
	int probe_res = mng_probe(dev);
	if (probe_res == 0) {
		res = 0;	//found at least one supported device
	}
  }

  if (res == 0) {
	  res = mng_proc_create_proc_entry(mng_devices);
  }
    
  if (res == 0) {
	  major = register_chrdev(0, 
							  MNG_DEV_NAME,
							  &mng_host_fops);

	  if (major < 0) {
		printk (KERN_DEBUG "MNG: Registering device %s failed with error %d\n",
		   MNG_DEV_NAME, major);
		return major;
	  }
  }

  return res;
}


void __exit mng_cleanup(void)
{
  mng_proc_destroy_proc_entry();

  if (mng_devices_cleanup()) {
    printk (KERN_DEBUG "MNG: Unregistering device %s failed\n",
	   MNG_DEV_NAME);
  }

  if (unregister_chrdev(major, MNG_DEV_NAME) <0) {
    printk (KERN_DEBUG "MNG: Unregistering device %s failed\n",
	   MNG_DEV_NAME);
  }
}


static int __init mng_devices_init(void) {
    
	int i;

	for (i=0; i<MNG_MAX_DEVICES; i++) {
		mng_devices[i].pcid = NULL;
		mng_devices[i].pci_hostif_access = NULL;
		mng_devices[i].pci_sem_regs_access = NULL;
		mng_devices[i].initialized = 0;
	}

	return 0;
}


static int __exit mng_devices_cleanup(void) {
	    
	int i;

	for (i=0; i<MNG_MAX_DEVICES; i++) {
        mng_dev_cleanup(&(mng_devices[i]));
	}

	return 0;
}


static int __init mng_probe(struct pci_dev *pcid)
{
  int res;
  static int cur_dev = 0;

  if(mng_is_supported(pcid)){
    return -1;
  }
  
  pci_set_master(pcid) ; 

  // should we wake the device if it's suspended?
  if(pci_enable_device(pcid)){
    return -ENODEV;
  }

  if( (res = mng_dev_init(pcid, &mng_devices[cur_dev])) != 0 )
    return res;

  cur_dev++;
  
  return 0;
}


static int mng_dev_init(struct pci_dev *pcid, struct mng_dev *dev)
{
  unsigned long mem, pci_mem;
  int err;

  pci_mem = mng_iomem(pcid);
  mem = pci_mem;
	  
  mem = MNG_PAGE_ALIGN(mem + MNG_SEM_REGS_START_OFFSET);
  dev->pci_sem_regs_access = ioremap_nocache(mem, PAGE_SIZE);
  if (dev->pci_sem_regs_access == NULL) {
	  mng_dev_cleanup(dev);
	  return -ENOMEM;
  }
  dev->pci_sem_regs_access += MNG_PAGE_OFFSET(MNG_SEM_REGS_START_OFFSET);  

  mem = pci_mem;
  mem = MNG_PAGE_ALIGN(mem + MNG_HOSTIF_START_OFFSET);
  dev->pci_hostif_access = ioremap_nocache(mem, PAGE_SIZE);
  if (dev->pci_hostif_access == NULL) {
	  mng_dev_cleanup(dev);
	  return -ENOMEM;
  }
  dev->pci_hostif_access += MNG_PAGE_OFFSET(MNG_HOSTIF_START_OFFSET);  
  dev->pcid = pcid;
  err = mng_dev_wdog_init(dev);
  if (err) {
	  return err;
  }

  err = mng_reboot_nt_register(dev);
  if (err) {
	  return err;
  }  
  
#ifdef CONFIG_PM
  err = mng_pm_register(dev);
  if (err) {
	  return err;
  }
#endif

  init_MUTEX(&(dev->host_cmd_sem));
  dev->initialized = 1;
  return 0;
}


static int mng_dev_cleanup(struct mng_dev *dev) {
		
	int err;

	if (dev->initialized) {

#ifdef CONFIG_PM
		mng_pm_unregister(dev);
#endif

		err = mng_reboot_nt_unregister(dev);
		if (err) {
			return err;
		}  

		err = mng_dev_wdog_cleanup(dev);
		if (err) {
			return err;
		}

		if(dev->pci_sem_regs_access != NULL) {
			iounmap(dev->pci_sem_regs_access - MNG_PAGE_OFFSET(MNG_SEM_REGS_START_OFFSET));
		}
		if(dev->pci_hostif_access != NULL) {
			iounmap(dev->pci_hostif_access - MNG_PAGE_OFFSET(MNG_HOSTIF_START_OFFSET));
		}

		dev->pci_sem_regs_access = NULL;
		dev->pci_hostif_access = NULL;

		dev->initialized = 0;
	}

	return 0;
}


loff_t mng_host_llseek(struct file *filp, loff_t off, int whence)
{
	return -ESPIPE; /* unseekable */
}

int	mng_host_open(struct inode *inode, struct file *filp) {
 
	struct mng_dev *dev = &(mng_devices[MINOR(inode->i_rdev)]); 
	if (dev->initialized == 0) {
        return -ENODEV;
	}

	filp->private_data = dev;
	return 0;   
}

int mng_host_release(struct inode *inode, struct file *filp) {
	return 0;
}


static int check_reg_access_valid(struct mng_reg_access *reg_access) {

	//if accessing MNG_SWSM_OFFSET register or MNG_FWSM_OFFSET register
	if((reg_access->byte_offset == MNG_SWSM_OFFSET) ||
	   (reg_access->byte_offset == MNG_FWSM_OFFSET)){
		return 0;
	} else {
		return -EFAULT;
	}
}


void mng_data_read(void *mem_ptr, __u16 num_dwords, __u32 *out_data) {
	int i;
	for (i=0; i<num_dwords; i++) {
		out_data[i] = MNG_REG_READ(mem_ptr + i*sizeof(__u32));
	}
}


void mng_data_write(void *mem_ptr, __u16 num_dwords, __u32 *in_data) {
	int i=0;
	for (i=0; i<num_dwords; i++) {
		MNG_REG_WRITE(in_data[i], mem_ptr + i*sizeof(__u32));
	}
}


void mng_sem_reg_read(struct mng_dev *dev, __u16 byte_offset, __u32 *out_data) {
	mng_data_read(MNG_GET_SEMREGS_MEM_PTR(dev, byte_offset), 
				  1,
				  out_data);
}


void mng_sem_reg_write(struct mng_dev *dev, __u16 byte_offset, __u32 *in_data) {
	mng_data_write(MNG_GET_SEMREGS_MEM_PTR(dev, byte_offset), 
				   1,
				   in_data);
}


int mng_host_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg) {

	struct mng_dev *dev;
	__u16 if_version;
	int err=0;
	__u8 *user_addr = (__u8 *)(arg);

	//extract the type and number bitfields, and don't decode
	//wrong cmds: return EINVAL before access_ok()
	if (_IOC_TYPE(cmd) != MNG_HOST_IOC_MAGIC) return -EINVAL;
	if (_IOC_NR(cmd) > MNG_HOST_IOC_MAXNR) return -EINVAL;

	dev = (struct mng_dev *)filp->private_data;

	//check interface version:
	if (copy_from_user(&if_version, user_addr, sizeof(__u16))) {
		return -EFAULT;
	}

	if ( (MNG_HOST_IF_GET_MAJOR_VER(if_version) != MNG_HOST_IF_VER_MAJOR) ||
		 (MNG_HOST_IF_GET_MINOR_VER(if_version) > MNG_HOST_IF_VER_MINOR) ) {
		printk (KERN_DEBUG 
				"MNG: Supported host i/f version (%d.%d) is incompatible with received ioctl version (%d.%d)\n", 
				MNG_HOST_IF_VER_MAJOR, MNG_HOST_IF_VER_MINOR, 
				MNG_HOST_IF_GET_MAJOR_VER(if_version), MNG_HOST_IF_GET_MINOR_VER(if_version));
		return -EINVAL;
	}

	switch (cmd) {
	case MNG_HOST_IOC_DO_CMD: {
		
		struct mng_host_cmd_ioc cmd_ioc;
		struct host_command cmd;

		if (!capable(CAP_NET_ADMIN)) {
			return -EPERM;		
		}

		if (copy_from_user(&cmd_ioc, user_addr, sizeof(cmd_ioc))) {
			return -EFAULT;
		}

		if (copy_from_user(&cmd, cmd_ioc.cmd, sizeof(cmd))) {
			return -EFAULT;
		}

		err = mng_do_host_cmd(dev, &cmd);
		if (err) {
			return err;
		}

		if(copy_to_user(cmd_ioc.cmd,
						&cmd, 
						sizeof(cmd_ioc))) {
			return -EFAULT;
		}
			
		return 0;
	}

	case MNG_HOST_IOC_REG_READ: {

		struct mng_reg_access reg_access;
		
		if (!capable(CAP_NET_ADMIN)) {
			return -EPERM;		
		}

		if (copy_from_user(&reg_access, user_addr, sizeof(reg_access))) {
			return -EFAULT;
		}

		if (check_reg_access_valid(&reg_access)) {
			return -EINVAL;
		}

		if (dev->pci_sem_regs_access == NULL) {
			return -ENOMEM;
		}

		mng_sem_reg_read(dev, reg_access.byte_offset, &(reg_access.reg_data));

		if (copy_to_user(user_addr, &reg_access, sizeof(reg_access))) {
			return -EFAULT;
		}

		return 0;
	}

	case MNG_HOST_IOC_REG_WRITE: {

		struct mng_reg_access reg_access;
		
		if (!capable(CAP_NET_ADMIN)) {
			return -EPERM;		
		}

		if (copy_from_user(&reg_access, user_addr, sizeof(reg_access))) {
			return -EFAULT;
		}

		if (check_reg_access_valid(&reg_access)) {
			return -EINVAL;
		}

		if (dev->pci_sem_regs_access == NULL) {
			return -ENOMEM;
		}

		mng_sem_reg_write(dev, reg_access.byte_offset, &(reg_access.reg_data));

		return 0;
	}

	case MNG_HOST_IOC_WDOG_START_STOP: {
		
		struct mng_wdog_info wdog_info;
		int ret=0;
		
		if (!capable(CAP_NET_ADMIN)) {
			return -EPERM;		
		}

		//check if host i/f is enabled by checking the mode in the FWSM reg
		if (mng_host_if_enabled(dev)) {
			printk(KERN_DEBUG "MNG: HOST-IF not active\n");
			return -EIO;
		}

		if (copy_from_user(&wdog_info, user_addr, sizeof(wdog_info))) {
			return -EFAULT;
		}

		down(&(dev->wdog.wdog_sem));	
		if(wdog_info.enable) {
			dev->wdog.interval = wdog_info.interval;
			if (dev->wdog.status == MNG_WDOG_RUNNING) {
				mng_stop_watchdog_process(dev);
			}
			mng_start_watchdog_process(dev);
		} else {
			if (dev->wdog.status == MNG_WDOG_RUNNING) {
				mng_stop_watchdog_process(dev);
			} else {
				//if watchdog was not running, just send "stop wdog" host i/f command
				if (mng_host_cmd_stop_wdog(dev)) {
					ret = -EIO;
					goto out;
				}
			}
		}
		
		out:
		up(&(dev->wdog.wdog_sem));        
		return ret;
	}

	case MNG_HOST_IOC_WDOG_GET_INFO: {
		
		struct mng_wdog_info wdog_info;
		
		if (!capable(CAP_NET_ADMIN)) {
			return -EPERM;		
		}

		down(&(dev->wdog.wdog_sem));
		wdog_info.if_version = if_version;
		wdog_info.enable = (dev->wdog.status == MNG_WDOG_RUNNING)?1:0;
		wdog_info.interval = dev->wdog.interval;
		wdog_info.last_reset_time = dev->wdog.last_reset;
		up(&(dev->wdog.wdog_sem)); 

		if (copy_to_user(user_addr, &wdog_info, sizeof(wdog_info))) {
			return -EFAULT;
		}

		return 0;
	}

	default:
		return -EINVAL;
	}
}



#ifdef MODULE_LICENSE
MODULE_LICENSE("GPL");
#endif

MODULE_AUTHOR("Intel Corporation, <linux.nics@intel.com>");
MODULE_DESCRIPTION(MNG_DEV_NAME" Host interface driver. Version " COMPONENT_VERSION);



EXPORT_NO_SYMBOLS;


module_init(mng_init);
module_exit(mng_cleanup);


