REM RMCP+ parameter configuration in Pass-Through mode
REM ==================================================

REM SMBUS slave address = 0x04.
REM SMBUS command = 0xE0.
REM UserID = 0x00.
REM Tag number(all commands) = 0x01.


REM Command = 0x01. (Update user name)
REM User privilege level = 0x02.
REM User name = "Intel". (length=0x05. value=0x49 0x6E 0x74 0x65 0x6C)
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x0A 0x01 0x01 0x00 0x02 0x05 0x49 0x6E 0x74 0x65 0x6C
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0xE0. (Read parameters)
REM Parameter = 0x01 (user name)
REM Sub-parameter = 0x00 (user ID)
REM ---------------------------------------------------------------

blwrite 0x04 0xE0 0x04 0x01 0xE0 0x01 0x00
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xE1 0x01 0x00 0x02 0x05 0x49 0x6E 0x74 0x65 0x6C



REM Command = 0x02. (Update user password)
REM User password = 0102030405060708090A0B0C0D0E0F1011121314.
REM ---------------------------------------------------------------

blwrite 0x04 0xE0 0x17 0x01 0x02 0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F 0x10 0x11 0x12 0x13 0x14
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x03. (Update security keys)
REM KR = 0102030405060708090A0B0C0D0E0F1011121314.
REM ---------------------------------------------------------------

blwrite 0x04 0xE0 0x17 0x01 0x03 0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F 0x10 0x11 0x12 0x13 0x14
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x03. (Update security keys)
REM KG = 0102030405060708090A0B0C0D0E0F1011121314.
REM ---------------------------------------------------------------

blwrite 0x04 0xE0 0x17 0x01 0x03 0x01 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F 0x10 0x11 0x12 0x13 0x14
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x04. (Update Channel information)
REM Channel privilege level = 0x02. (User)
REM ---------------------------------------------------

blwrite 0x04 0xE0 0x03 0x01 0x04 0x02
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x05. (Update BMC GUID)
REM BMC GUID = 000102030405060708090A0B0C0D0E0F.
REM ---------------------------------------------------

blwrite 0x04 0xE0 0x12 0x01 0x05 0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x06. (Set session Ids)
REM Base session ID = 0x00 0x00 0x00 0x01.
REM Number of session IDs = 0x10.
REM ---------------------------------------------------

blwrite 0x04 0xE0 0x07 0x01 0x06 0x00 0x00 0x00 0x01 0x10
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x2D. (Set Inactivity timeout)
REM Inactivity Timeout = 0x01. (30 seconds)
REM ---------------------------------------------------

blwrite 0x04 0xE0 0x03 0x01 0x2D 0x01
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00



REM Command = 0x35. (Set user payload access)
REM PAyload enables 1 = 0x01 (enable user to activate SOL on this channel)
REM ---------------------------------------------------

blwrite 0x04 0xE0 0x05 0x01 0x35 0x00 0x01 0x00
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00